require "gtk"

module Dpklib_Gtk
  CASCADE_HORIZONTAL = 0
  CASCADE_VERTICAL = 1

  class CascadingTable < Gtk::Table
    attr_accessor(:x_attach_options, :y_attach_options,
                  :cascading, :row_spacing, :col_spacing)
    def initialize(cnt_row, cnt_col, *args, &block)
      super
      @cascading = CASCADE_HORIZONTAL
      @x_attach_options = @y_attach_options = 0
      @cnt_row, @cnt_col = cnt_row, cnt_col
      @curr_row, @curr_col = 0, 0
    end

    def spacing=(spacing)
      @row_spacing = @col_spacing = spacing
    end

    def attach_options=(options)
      @x_attach_options = @y_attach_options = options
    end

    def attach_cascade(widget)
      @row_spacing && set_row_spacing(@curr_row, @row_spacing)
      @col_spacing && set_col_spacing(@curr_col, @col_spacing)
      attach(widget, @curr_col, @curr_col + 1,
             @curr_row, @curr_row + 1,
             @x_attach_options, @y_attach_options)
      
      case @cascading
      when CASCADE_HORIZONTAL
        @curr_col += 1
        if @curr_col >= @cnt_col
          @curr_row += 1
          @curr_col = 0
        end
      when CASCADE_VERTICAL
        @curr_row += 1
        if @curr_row >= @cnt_row
          @curr_col += 1
          @curr_row = 0
        end
      end
    end
  end #/CascadingTable
end #/Dpklib_Gtk
