require "dpklib/resource"
require "rbconfig"

module Dpklib
  class HomeDotDir
    include Dpklib::ResourceFindable
    attr_reader :progname, :home_dir, :share_dir, :envname, :resource
    def initialize(progname)
      @progname = progname
      @home_dir = File.expand_path("~/.#{progname}")
  
      @share_dir = File.expand_path("#{progname}/dot-#{progname}",
                                    Config::CONFIG["datadir"])
      @envname = "#{progname.gsub('-', '_').upcase}_HOMEDOT"

      @resource = Dpklib::ResourceLoader.new
      @resource << @share_dir
      @resource << Dpklib.parse_env_to_pathes(@envname)
      @resource << @home_dir
    end

    def load_path
      @resource.load_path
    end
  end #/HomeDotDir
end #/Dpklib
