require 'dpklib/dpkstd'
require 'date'
require 'dpklib/time2date'
require 'dpklib/hour'
require 'dpklib/monthday'

Dpklib.local_load(__FILE__) do
  require 'parser'
  require 'composer'
end

module Dpklib
  class TimeArea
    ParseError = Class.new(StandardError)
    WDAY = %w(sun mon tue wed thu fri sat)

    module Condition
      # empty means '*' (matches all)
      def ===(rhs)
        if empty? then
          true
        else
          found = find { |i|
            (i === rhs)
          }
          (found != nil)
        end
      end
    end #/Condition

    attr_reader :monthdays, :wdays, :hours
    attr_accessor :etc
    def initialize
      cond = []
      cond.extend Condition

      @monthdays = cond.clone
      @wdays = cond.clone
      @hours = cond.clone
      @etc = nil
    end

    def ===(rhs)
      b = true
      case rhs
      when Time
        b = b && (@monthdays === Dpklib::MonthDay.from_date(rhs.ldate) )
        b = b && (@wdays === rhs.wday)
        b = b && (@hours === Dpklib::Hour.from_time(rhs) )
      when Date
        b = b && (@wdays === rhs.wday)
        b = b && (@monthdays === Dpklib::MonthDay.from_date(rhs) )
      when Dpklib::Hour
        b = b && (@hours === rhs)
      when Dpklib::MonthDay
        b = b && (@monthdays === rhs )
      else
        b = super
      end
      b
    end

    def ==(other)
      case other
      when TimeArea
        b = true
	b &&= @monthdays == other.monthdays
        b &&= @wdays == other.wdays
        b &&= @hours == other.hours
        b &&= @etc == other.etc
        b
      else
	false
      end
    end

    def to_s
      composer = TimeAreaComposer.new
      composer.timearea = self
      composer.perform
    end

    def inspect
      "#{super}[#{to_s}]"
    end
  end #/TimeArea

  class << TimeArea
    def parse(string)
      parser = TimeAreaParser.new
      parser.string = string
      parser.perform
    end

    alias [] parse
  end #/<< TimeArea
end #/Dpklib
