require "dpklib/homedot"
require "rbconfig"
require "runit/testcase"

class TESTCASE_HomeDotDir < RUNIT::TestCase
  def test_it
    homedot_dir = Dpklib::HomeDotDir.new("testprog")
    assert_equals File.expand_path("~/.testprog"), homedot_dir.home_dir

    share_dir = File.expand_path("testprog/dot-testprog",
                                 Config::CONFIG["datadir"])
    assert_equals share_dir, homedot_dir.share_dir
    assert_equals "TESTPROG_HOMEDOT", homedot_dir.envname
  end
end #/TESTCASE_HomeDotDir
