require "date"
require "dpklib/timeutils"
require "rubyunit"

class TESTCASE_TimeUtils < RUNIT::TestCase
  def test_time_to_date
    testtime = Time.now    
    date = Dpklib.time_to_date(testtime)

    assert_equals testtime.year, date.year
    assert_equals testtime.month, date.month
    assert_equals testtime.day, date.day
  end

  def test_date_to_time
    testdate = Date.today
    time = Dpklib.date_to_time(testdate, 1, 2, 3)
    
    assert_equals testdate.year, time.year
    assert_equals testdate.month, time.month
    assert_equals testdate.day, time.day
    assert_equals 1, time.hour
    assert_equals 2, time.min
    assert_equals 3, time.sec
  end

  def test_parse
    assert_equals Date.new(2002, 10, 11), Dpklib.parse_date("2002/10/11")
    assert_exception(Dpklib::DateParseError) {
      Dpklib.parse_date("")
    }
    assert_equals Time.local(2002, 10, 11, 2, 5, 30), Dpklib.parse_timestamp("2002/10/11 02:05:30")
    assert_exception(Dpklib::TimestampParseError) {
      Dpklib.parse_timestamp("")
    }
  end
end #/TESTCASE_TimeUtils
