require "dpklib/class"

module Dpklib
  class CompareWrapper
    attr_reader :compare_wrapper_obj
    def initialize(obj)
      @compare_wrapper_obj = obj
    end

    def eql?(rhs)
      if rhs.respond_to?(:to_comparable)
        to_comparable.eql?(rhs.to_comparable)
      else
        @compare_wrapper_obj.eql?(rhs)
      end
    end
    alias == eql?
    alias === eql?
    
    def to_s
      @compare_wrapper_obj.to_s
    end

    def inspect
      @compare_wrapper_obj.inspect
    end

    def to_comparable
      comparable_object(@compare_wrapper_obj)
    end

    def comparable_object(obj)
      Dpklib.implemented_by_subclass
    end
  end #/CompareWrapper

  class WSIgnoredCompareWrapper < CompareWrapper
    def comparable_object(obj)
      obj.gsub(/\s+/, "")
    end
    class << self
      alias [] new
    end #/<< self
  end #/WSIgnoredCompareWrapper
end #/Dpklib
