# interop is Interoperability.
require "kconv"

module Dpklib
end #/Dpklib

class << Dpklib
  def normalize_string_encoding(string)
    case $KCODE
    when "EUC"
      string = Kconv.toeuc(string)
    when "SJIS"
      string = Kconv.tosjis(string)
    else
      string = string.dup
    end
    string
  end

  def normalize_string_newline(string)
    string = string.dup
    string.gsub!("\r\n", "\n")
    string.gsub!("\r", "\n")
    string
  end  
end #/<< Dpklib
