require 'webrick/httpservlet/abstract'
require 'webrick/httpstatus'

module Dpklib_WEBrick
  class ActionCGIHandler < WEBrick::HTTPServlet::AbstractServlet
    def initialize(server, local_path, action_script_path)
      super
      @local_path = local_path
      @action_script_path = action_script_path
    end
    
    def do_GET(request, response)
      data = get_cgi_output(request)
      set_response_from_cgi_output(request, response, data)
      nil
    end
    
    protected
    def get_cgi_output(request)
      env = cgi_env(request)
      data = nil
      IO::popen("-", "r+") do |io|
        unless io then
          exec_child_process(env)
        end

        body = request.body
        if body && body.size > 0 then
          io.write(body)
        end
        io.close_write
        data = io.read || ""

        Process.waitpid(io.pid)
      end

      $? == 0 || raise_server_error("The program exited with status #{$?}.")
      data
    end

    def cgi_env(request)
      meta = request.meta_vars
      meta["TRANSLATED_PATH"] = @local_path
      meta
    end

    def exec_child_process(env)
      env.each { |name, value|
        ENV[name] = value if value
      }
      exec @action_script_path
    end

    # from CGIHandler#do_GET
    def set_response_from_cgi_output(request, response, data)
      raw_header, body = data.split(/^[\xd\xa]+/on, 2) 
      body || raise_server_error("The program omitted the response body.")
      
      header = Hash.new
      field = nil
      raw_header.each{|line|
        line.chop!
        case line
        when /^([A-Za-z0-9_-]+):\s*(.*)$/o
          field, value = $1, $2
          field.downcase!
          header[field] = value
        when /^[\t ]+(.*)$/o
          field || raise_server_error("The program had returned invalid header.")
          header[field] << value
        when /^$/o
          break
        else
          raise_server_error("The program had returned invalid header.")
        end
      }
      
      if /^(\d+)/ =~ header['status']
        response.status = $1.to_i
        header.delete('status')
      end
      header.each{|key, val| response[key] = val }
      response.body = body
      response
    end
    
    def raise_server_error(msg)
      msg = "ActionCGIHandler: #{msg}"
      raise(WEBrick::HTTPStatus::InternalServerError, msg)
    end
    
    alias do_POST do_GET
  end #/ActionCGIHandler
  
end #/Dpklib_WEBrick
