require "base64"
require "webrick/httprequest"
require "webrick/httpserver"

module Dpklib_WEBrick
  module HttpServerMixin_BasicAuthUserByPrefixedPath
    BASIC_AUTH_REQFIELD = "Authorization".downcase
    def service(request, response)
      path = request.path
      unless request[BASIC_AUTH_REQFIELD]
        if %r'\A/([^/]+)(/.*)\z' =~ path
          username = $~[1]

          auth_token = encode64("#{username}:")
          request.header[BASIC_AUTH_REQFIELD] = ["Basic #{auth_token}"]
          request.path = $~[2]
          @logger.debug("Path '#{path}' is mapped to user '#{username}' and trimed to '#{request.path}'.")
        end
      end
      super
    end
  end #/HttpServerMixin_BasicAuthUserByPrefixedPath

  class UserPathHttpServer < WEBrick::HTTPServer
    include HttpServerMixin_BasicAuthUserByPrefixedPath
  end #/UserPathHttpServer
end #/Dpklib_WEBrick
