=begin
=TestRunner.rb
A test runner UI for the console.
=end

#<standard_header>
#
# Copyright (C) 2000-2001 Nathaniel Talbott
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#</standard_header>

require 'Lapidary/UI/TestRunnerMediator'
require 'Lapidary/UI/TestRunnerUtilities'

module Lapidary
	module UI
		module Console
			class TestRunner
				extend TestRunnerUtilities

				def TestRunner.run(suite)
					new(suite).start
				end
				def initialize(suite)
					@suite = suite
				end
				def start
					setupMediator
					attachToMediator
					startMediator
				end
				def setupMediator
					@mediator = TestRunnerMediator.new(@suite)
					suiteName = @suite.to_s
					if ( @suite.kind_of?(Module) )
						suiteName = @suite.name
					end
					puts("Loaded suite " + suiteName)
				end
				def attachToMediator
					@mediator.tuner.addListener(TestRunnerMediator::FAULT_ADDED, method(:addFault))
					@mediator.tuner.addListener(TestRunnerMediator::RESULT_CHANGED, method(:resultChanged))
					@mediator.tuner.addListener(TestRunnerMediator::STATUS_CHANGED, method(:updateStatus))
				end
				def startMediator
					@mediator.runSuite
				end
				def addFault(fault)
					puts
					puts(fault.longDisplay)
				end
				def resultChanged(result)
					@result = result
					$defout.write(".")
				end
				def updateStatus(status)
					if ( status.type == Status::STARTED_RUNNING )
						puts( status.message )
					elsif ( status.type == Status::FINISHED_RUNNING )
						puts
						puts( status.message )
						puts( @result )
					end
				end
			end
		end
	end
end

if __FILE__ == $0
	Lapidary::UI::Console::TestRunner.startCommandLineTest
end
