#!/usr/bin/ruby
=begin
  make2html -- create html from rd.

  Copyright (C) 2001,2002 MUTOH Masao <mutoh@highway.ne.jp>
  You may redistribute it and/or modify it under the same
  license terms as Ruby.
=end
require 'config.rb'

if __FILE__ != $0
require 'rd/rd2html-lib'

module RD
  class YARDHTMLExtVisitor < RD2HTMLVisitor
    # must-have constants
    OUTPUT_SUFFIX = "html"
    INCLUDE_SUFFIX = ["html"]
    
    METACHAR = { "<" => "&lt;", ">" => "&gt;", "&" => "&amp;" }

    attr(:head, true)

    def initialize
      super
      @title = $MH_TITLE
    end

    def apply_to_TextBlock(element, content) 
     if (element.parent.is_a?(ItemListItem) or
	  element.parent.is_a?(EnumListItem) or
	  element.parent.is_a?(MethodListItem))
	content.join.chomp
      else
	content = content.delete_if{|x| x == "\n"}.join("").gsub(/\n/, "<br />\n")
	%Q[<p>#{content.chomp}</p>]
      end
    end

    def apply_to_Verbatim(element)
      if (element.parent.is_a?(ItemListItem) or
	  element.parent.is_a?(EnumListItem) or
	  element.parent.is_a?(MethodListItem))
	content = []
	element.each_line do |i|
	  content.push("<br />" + apply_to_String(i).chomp)
	end
	content.join("").chomp
      else
	content = []
	element.each_line do |i|
	  content.push(apply_to_String(i))
	end
	%Q[<pre>#{content.join("").chomp}</pre>]
      end
    end

    def link_to_css
      %|<link href="../style.css" type="text/css" rel="stylesheet" />|
    end

    def html_head
      ret = %|<head>\n|
	ret << html_title + "\n"
      ret << html_content_type + "\n" if html_content_type
      ret << link_to_css + "\n" if link_to_css
      ret << forward_links + "\n" if forward_links
      ret << backward_links + "\n" if backward_links
      ret << head + "\n" if head
      ret << %Q[</head>]
    end 

    def html_body(contents)
	  id = contents.last
	  contents.delete(id)
      if defined? $MH_LICENSE and defined? $MH_COPYRIGHT
		license = meta_char_escape($MH_LICENSE).gsub(/\n/, "<br />")
		copyright = meta_char_escape($MH_COPYRIGHT).gsub(/\n/, "<br />")
		contents << "<h2>License</h2>"
		contents << "<p>"
		contents << copyright + "<br /><br />"
		contents << license
		contents << "</p>"
      end

      if FileTest.exist?("../ChangeLog")
		contents << "<h2>ChangeLog</h2>"
		file = open("../ChangeLog", "r")
		list = Array.new
		cnt = -1
		file.each_line do |line|
		  str = meta_char_escape(line.chomp)
		  if str =~ /^(\w.*)$/
			contents << "<ul>" + list.join("\n") + "</ul>" if list.size > 0
			contents << "<p>" + $1 + "</p>"
			list = Array.new
			cnt = -1
		  elsif str =~ /\s*\*\s*(.*)$/
			if cnt > 0 and list[cnt] 
			  list[cnt] += "</li>" 
			end
			cnt += 1
			list[cnt] = "<li>" + $1 + "<br />\n"
		  elsif str =~ /^\s*$/
			#do nothing.
		  else
			list[cnt] += str + "<br />\n"
		  end
		end
		file.close
		contents << "<ul>" + list.join("\n") + "</ul>" if list.size > 0
      end
	  contents << "<HR>" + id
      super(contents)
    end
  end
end
$Visitor_Class = RD::YARDHTMLExtVisitor
end

if __FILE__ == $0
  navigationbar = ""
  Dir.glob("rd/*/*rd").sort.each do |file|
    lang = /^rd\/(..)/.match(file).to_a[1]
    name = File.basename(file, ".rd")

    file = open("rd/#{lang}/LANGUAGE", "r")
    language = file.read.chomp!
    file.close

    navigationbar += %Q[<a href="../#{lang}/#{name}.html">[#{language}] </a>\n]
  end
  navigationbar += "<br /></p>"

  Dir.glob("rd/*/*rd").each do |file|
    name = File.basename(file, ".rd")
    lang = /^rd\/(..)/.match(file).to_a[1]
    
    header = %Q[<p><a href="#{$MH_BACKURL[1]}index_#{lang}.html">[#{$MH_BACKURL[0]}] </a>\n] + navigationbar
    print("rd/#{lang}/#{name}.rd -> html/#{lang}/#{name}.html\n")
    result = open("|rd2 -r makehtml.rb rd/#{lang}/#{name}.rd", "r").read
    
    result.gsub!(/<body>/, "<body>" + header)
    result.gsub!(/\(\(\*/, "<em>")
    result.gsub!(/\*\)\)/, "</em>")
    result.gsub!(/\(\(VERSION\)\)/, $MH_VERSION)
    
    file = open("html/#{lang}/#{name}.html", "w")
    file.print(result)
    file.close
  end
end

