# -*- ruby -*-
#
# Using an internal stack.
#

require 'xtemplate'
require 'xtemplate/xml'

data = {
  'members' => [
    {'name' => 'name1', '@uid' => 1, 'email' => '<name1@com>'},
    {'name' => 'name2', '@uid' => 2, 'email' => '<name2@com>'},
    {'name' => 'name3', '@uid' => 3, 'email' => '<name3@com>'},
  ]
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<members xmlns:xt="#{XTemplate::BIND_URI}">
   <xt:select id="/members{tag}">
     <xt:copy-of id="tag" with="member" />
   </xt:select>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
