# -*- ruby -*-

require 'xtemplate'
require 'xtemplate/hash'
require 'dbi'

module XTemplate
  class DBIConnector
    include XData

    def initialize(dbh)
      @dbh = dbh
      @opts = {}
    end

    def handle
      @dbh
    end

    def set_option(key, str)
      @opts[key] = str
    end

    def keys
      @dbh.tables
    end

    def to_hash
      Hash.new{|hash,key|
	unless( key == TextNode )
	  tbl,*opt = key.split(":")
	  if( @dbh.tables.any?{|t| t.upcase == tbl.upcase} )
	    ary = []
	    opt = opt.collect{|k| @opts[k] || '' }.join(' ')
	    query = "SELECT * FROM #{tbl} #{opt}"
	    @dbh.execute(query){|sth|
	      while( h = sth.fetch_hash )
		ary.push(h)
	      end
	    }
	    hash[key] = ary
	  end
	end
      }
    end
  end
end

if( __FILE__ == $0 )
  include XTemplate
  dbh = DBI.connect("dbi:SQLite:foo")
  dbh.do("CREATE TABLE MEMBER (name VARCHAR(25), uid INT, age INT)")
  for i in 0..20
    dbh.do("INSERT INTO MEMBER VALUES ('name#{i}',#{i}, #{rand(70)})")
  end
  dbh.commit

  obj = XTemplate::DBIConnector.new(dbh)
  obj.set_option('limit5', 'LIMIT 0, 5')
  obj.set_option('limit10', 'LIMIT 0, 10')
  obj.set_option('order_by_uid', 'ORDER BY uid DESC')
  obj.set_option('order_by_age', 'ORDER BY age DESC')

  text = <<EOF
<?xml version="1.0"?>
<members id="dbi">
  <member id="member:order_by_age{attr(uid)}">
    <name id="name" /><age id="age" />
  </member>
</members>
EOF

  data = {'dbi' => obj}

  print(XMLTemplate.new(text).expand(data))
end
