=begin
  $Id: perftest_bitvector.rb,v 1.1.1.1 2002/12/02 11:22:20 knu Exp $

  Performance tests for BitVector.

=end
require 'bitvector'
require 'benchmark'
include Benchmark

nl = 100000
sl = 7895
ns = 10000
ss = 250
nss = 1000

bm(25) do |x|
  puts "#{nl}#, size(#{sl}) FAST"
  x.report("succ") {
    b = BitVector.new(sl)
    nl.times{ b.succ }
  }
  x.report("flip") {
    b = BitVector.new(sl)
    nl.times{ b.flip }
  }
  x.report("rotate_left") {
    b = BitVector.new(sl)
    nl.times{ b.rotate_left }
  }
  x.report("complement") {
    b = BitVector.new(sl)
    nl.times{ b.complement }
  }
  x.report("set_difference") {
    b = BitVector.new(sl).randomize
    a = BitVector.new(sl).randomize
    nl.times{ a.difference(b) }
  }
  x.report("add") {
    b = BitVector.new(sl).randomize
    a = BitVector.new(sl).randomize
    nl.times{ a+b }
  }
  x.report("init_and_clear") {
    nl.times{ b = BitVector.new(sl) }
  }
  puts "#{ns}#, size(#{ss}) SLOW"
  x.report("randomize_0.5") {
    a = BitVector.new(ss)
    ns.times{ 
      a.randomize(0.5)
    }
  }
  x.report("to_uint") {
    a = BitVector.new(ss).randomize
    ns.times{ a.to_uint }
  }
  x.report("to_i") {
    a = BitVector.new(ss).randomize
    ns.times{ a.to_i }
  }
  x.report("divide") {
    b = BitVector.new(ss).randomize
    a = BitVector.new(ss).randomize
    ns.times{ a/b }
  }
  x.report("multiply") {
    b = BitVector.new(ss).randomize
    a = BitVector.new(ss).randomize
    ns.times{ a*b }
  }
  x.report("randomize_non_0.5") {
    a = BitVector.new(ss)
    ns.times{ 
      a.randomize(0.4)
    }
  }
end



