require "dpklib/simplecfg"
require "rubyunit"

class TESTCASE_SimpleConfig < RUNIT::TestCase
  def test_it
    config_spec = Dpklib::SimpleConfigSpec.new(3)
    result = config_spec.parse_text(TESTDATA_1)

    expected = [
      ["a", "b", "c d"],
      ["r", "s", "t"],
      ["x", "y"],
      ["whitespace_ignored"]
    ]

    assert_equals expected, result
  end

  def test_no_fieldnum
    config_spec = Dpklib::SimpleConfigSpec.new
    assert_equals "a b c", config_spec.parse_line("a b c")
  end

TESTDATA_1 = <<EOF
# this is a comment
a b c d
r s t
x y

     whitespace_ignored
EOF
end #/TESTCASE_SimpleConfig
