require 'rubyunit'

require 'dpklib/queueworker'

class TESTCASE_QueueWorker < RUNIT::TestCase
  def setup
    @processed = []
    @queue_worker = Dpklib::BGQueueWorker.new do |work|
      @processed << work
    end
  end

  def test_push
    @queue_worker.start
    @queue_worker.push 1
    @queue_worker.push 2
    @queue_worker.wait_clean do
      assert_equals @processed, [1, 2]
    end
  end

  def teardown
    @queue_worker.shutdown
  end

end #/TESTCASE_QueueWorker
