
module Dpklib
  class CommandLineProgram
    QuitException = Class.new(Exception)
    AbortException = Class.new(Exception)
    attr_accessor :argv, :stdin, :stdout, :stderr, :argv0, :progname

    def initialize(progname = nil)
      @argv = ARGV
      @stdin = $stdin
      @stdout = $stdout
      @stderr = $stderr
      @argv0 = $0
      @progname = progname
    end

    def start
    end

    def info(message)
      stderr.puts("#{progname}: #{message}")
    end

    def die(message)
      info(message)
      abort
    end

    def quit
      raise(QuitException)
    end

    def abort
      raise(AbortException)
    end

    def progname
      @progname ||= File.basename(@argv0)
    end

    def opt(optname)
      eval("$OPT_#{optname}")
    end

    module StartModule
      def start
        new.start
      end

      def execute
        begin
          start
        rescue AbortException
          exit 1
        rescue QuitException
        end
        exit 0
      end
      alias exec execute
    end #/StartModule

    def self.inherited(klass)
      super
      klass.extend(StartModule)
    end
  end #/CommandLineProgram
end #/Dpklib
