require "dpklib/class"

module Dpklib
  
end #/Dpklib

class << Dpklib
  module ErrorClass
    def initialize(*args, &block)
      super(init_message(*args, &block))
    end

    Dpklib.install_class_module(self) {
      def raise(*args, &block)
        $! = new(*args, &block)
        $!.set_backtrace(caller)
        Kernel.raise
      end
      alias fail raise
    }
  end #/ErrorClass

  def new_error_class(base_class = nil, &message_init_block)
    base_class ||= StandardError
    klass = Class.new(base_class)
    klass.module_eval {
      include ErrorClass
      if block_given?
        define_method(:init_message, &message_init_block)
      end
    }
    klass
  end

  def error_description(exception = $!)
    sprintf("%s (%s)", exception.to_s, exception.type)
  end

  def backtrace_message(backtrace = caller(1))
    lines = []
    backtrace.each do |line|
      lines << sprintf("  from %s", line)
    end
    lines.join("\n")
  end

  def stacktrace_message(exception = $!)
    lines = []

    lines << error_description(exception)
    lines << backtrace_message(exception.backtrace)
    lines.join("\n")
  end
end #/<< Dpklib
