module Dpklib
  NoCharsetGivenError = Class.new(ArgumentError)

  def self.mkpasswd(length, *charsets)
    charsets = charsets.collect { |charset|
      Array(charset)
    }
    charsets.flatten!
    raise(NoCharsetGivenError) if charsets.size < 1

    max = charsets.size - 1
    passwd = ""
    length.times do
      passwd << charsets[rand(max)]
    end
    passwd
  end

  def self.mkpasswd_alphanum(length)
    mkpasswd(length, ?A..?Z, ?a..?z, ?0..?9)
  end
end #/Dpklib
