module Misen
  class Node
    attr_accessor :identifier
    def initialize
      @identifier = nil
    end

    def eql?(rhs)
      rhs.kind_of?(self.type) && (@identifier == rhs.identifier)
    end
    alias == eql?
    alias === eql?

    def hash
      @identifier.hash
    end
  end #/Node

  class BlockNode < Node
    attr_reader :children

    def initialize
      super
      @children = []
    end

    def eql?(rhs)
      super && (@children == rhs.children)
    end
    alias == eql?
    alias === eql?

    def hash
      [super, @children].hash
    end

    def to_s
      children.join
    end
  end #/BlockNode

  class InlineNode < Node
    attr_accessor :inline_style
    def format(string)
      @inline_style.format(string)
    end

    def to_s
      "<InlineNode:#{identifier}/>"
    end
  end #/InlineNode

  class << self
    def new_block_node(identifier, &children_block)
      node = BlockNode.new
      node.identifier = identifier
      node.children.replace(yield) if block_given?
      node
    end

    def new_inline_node(identifier, inline_style)
      node = InlineNode.new
      node.identifier = identifier
      node.inline_style = inline_style
      node
    end
  end #/<< self
end #/Misen
