require "misen/style"

module Misen
  STYLE_TEX = Style.new
  class << STYLE_TEX
    IDENT_RE = "[A-Za-z0-9_]+"

    def block_begin_regexp
      %r"\\begin\{misen:(#{IDENT_RE})\}"
    end

    def block_end_regexp
      %r"\\end\{misen:#{IDENT_RE}\}"
    end

    def inline_regexp
      %r"\\misen:(#{IDENT_RE})"
    end

    def block_get_identifier(matches)
      matches[1]
    end
    alias inline_get_identifier block_get_identifier
  end #/<< STYLE_TEX
end #/Misen
