require "dpklib/assert"
require "dpklib/class"
require "rubyunit"

class TESTCASE_ClassModule < RUNIT::TestCase
  module Mojule
    classmod = Dpklib.install_class_module(self) {
      def modmethod
        true
      end
    }

    extend RUNIT::Assert
    assert_equals classmod, self::ClassModule    
  end #/Mojule
  include Mojule
  
  extend RUNIT::Assert
  assert self.modmethod
end #/TESTCASE_ClassModule

class TESTCASE_EachargMethod < RUNIT::TestCase
  include Dpklib::EachargMethod
  def doit(one)
    one << "."
  end
  eacharg_method :doit

  def test_it
    ary = ["1", "2"]
    doit(*ary)
    assert_equals ["1.", "2."], ary
  end
end #/TESTCASE_EachargMethod

class TESTCASE_OnceMethod < RUNIT::TestCase
  class Klass
    include Dpklib::OnceMethod
    def initialize
      @test = 0
    end
    def test
      @test += 1
    end
    once_method :test
  end #/Klass

  def test_it
    k = Klass.new
    assert_equals 1, k.test
    assert_equals 1, k.test
  end
end #/TESTCASE_OnceMethod

class TESTCASE_AliasAccessor < RUNIT::TestCase
  class Klass
    include Dpklib::AliasAccessor
    attr_reader :r
    attr_writer :w
    attr_accessor :a
    
    alias_accessor :new_r, :r
    alias_accessor :new_w, :w
    alias_accessor :new_a, :a
  end #/Klass
  def test_it
    k = Klass.new
    
    k.new_a = 12
    assert_equals 12, k.a
  end
end #/TESTCASE_AliasAccessor

class TESTCASE_BacktraceRewriteMethod < RUNIT::TestCase
  MyError = Class.new(StandardError)
  class Klass
    include Dpklib::BacktraceRewriteMethod
    def x
      raise MyError
    end
    backtrace_rewrite_method MyError, :x
  end #/Klass
  def test_it
    k = Klass.new
    begin
      k.x
    rescue MyError
      stack_count = $!.backtrace.size - caller.size
      assert_equals 1, stack_count
    end
  end
end #/TESTCASE_BacktraceRewriteMethod

class TESTCASE_AbstractMethod < RUNIT::TestCase
  class Klass
    include Dpklib::AbstractMethod
    abstract_method :x
  end #/Klass
  def test_it
    k = Klass.new
    assert_exception(Dpklib::AbstractMethodCalledError) do
      k.x(12)
    end
    def k.x(i)
      i
    end
    assert_equals 12, k.x(12)
  end
end #/TESTCASE_AbstractMethod

class TESTCASE_DpkClass < RUNIT::TestCase
  include Dpklib::RUNIT_Assert

  def test_singleton_method
    hello = "Hello!"
    obj = Object.new
    Dpklib.install_singleton_method(obj, :hello) {
      hello
    }
    assert_equals hello, obj.hello
  end
end #/TESTCASE_DpkClass
