require "dpklib/error"

module Dpklib_Daemontools
  CannotParseSvstatLineError = Dpklib.new_error_class { |line|
    "Cannot parse as status line reported by svstat: `#{line}'"
  }

  UP, DOWN, ONCE, EXIT, PAUSE, CONTINUE, HUP, ALARM, INTERRUPT, TERM, KILL =
    %w'u d o x p c h a i t k'

  class DaemonStatus
    attr_reader :status_text
    attr_accessor :service_path
    def initialize
      @status_text = nil
    end

    def service_name
      File.basename(@service_path)
    end

    def update
      # todo: use popen and exec
      parse_svstat_line(`svstat '#{service_path}'`)
    end

    def control(*options)
      options.empty? || `svc -#{options.join("")} #{service_path}`
    end

    def has_log?
      File.directory?(log_service_directory)
    end

    def log_service_directory
      File.expand_path("log", @service_path)
    end

    def mainlog_directory
      File.expand_path("main", log_service_directory)
    end

    def mainlog_current_file
      File.expand_path("current", mainlog_directory)
    end

    LOGFILE_REGEXP = %r"\A(current|@)"
    def each_mainlog_file(&block)
      mainlog_dir = mainlog_directory
      Dir.foreach(mainlog_dir) { |file|
        next unless file =~ LOGFILE_REGEXP
        file = File.expand_path(file, mainlog_dir)
        yield(file)
      }
    end

    def parse_svstat_line(svstat_line)
      if svstat_line =~ %r'\A(.+?): (.+)\Z'
        @status_text = $2
      else
        #CannotParseSvstatLineError.raise(svstat_line)
        @status_text = "???"
      end
    end
  end #/DaemonStatus

  class << self
    def svstat(service_path)
      status = DaemonStatus.new
      status.service_path = service_path
      status.update
      status
    end
  end #/<< self
end #/Dpklib_Daemontools
