

module Dpklib
  class TimeAreaParser
    attr_accessor :string

    class FieldParser
      attr_accessor :field, :atom_parser, :range_exclude_end

      def perform
        case @field
        when "*"
          []
        else
          parse_field(@field)
        end
      end

      protected
      def parse_field(field)
        items = field.split(",")
        items.collect { |item|
          parse_item(item.strip)
        }
      end

      def parse_item(item)
        atoms = item.split("-", 2)
        case atoms.size
        when 1
          @atom_parser[atoms[0]]
        when 2
          Range.new(@atom_parser[atoms[0]],
                    @atom_parser[atoms[1]],
                    @range_exclude_end)
        end
      end
    end #/FieldParser

    def perform
      timearea = TimeArea.new

      fields = splited_fields
      field_parser = FieldParser.new

      field_parser.field = fields[0]
      field_parser.range_exclude_end = false
      field_parser.atom_parser = proc do |atom|
        atom =~ %r"\A([0-9]+)/([0-9]+)\Z"
        $~ || raise(TimeArea::ParseError, "invalid monthday atom: #{atom}")
        Dpklib::MonthDay[$1.to_i, $2.to_i]
      end
      timearea.monthdays.concat field_parser.perform

      field_parser.field = fields[1]
      field_parser.range_exclude_end = true
      field_parser.atom_parser = proc do |atom|
        atom =~ %r"\A([0-9]+):([0-9]+)\Z"
        $~ || raise(TimeArea::ParseError, "invalid hour atom: #{atom}")
        Dpklib::Hour[$1.to_i, $2.to_i]
      end
      timearea.hours.concat field_parser.perform

      field_parser.field = fields[2]
      field_parser.range_exclude_end = false
      field_parser.atom_parser = proc do |atom|
        atom = atom.downcase
        wday = TimeArea::WDAY.index(atom)
        wday || raise(TimeArea::ParseError, "invalid wday atom: #{atom}")
      end
      timearea.wdays.concat field_parser.perform

      timearea.etc = fields[3]
      timearea
    end

    protected
    def splited_fields
      fields = string.strip.split(/\s+/, 4)
      fields.size < 3 && raise(TimeArea::ParseError, "too few fields: #{string}")
      fields
    end
    
  end #/TimeAreaParser

end #/Dpklib
