=begin
=TC_TestSuite.rb
Contains tests for the TestSuite class
=end

#<standard_header>
#
# Copyright (C) 2000-2001 Nathaniel Talbott
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#</standard_header>

require 'Lapidary/TestCase'
require 'Lapidary/TF_Suite'

module Lapidary
	class TC_TestSuite < TestCase
		def setup
			@suite = TF_Suite.suite
		end
		def testSize
			assertBlock("The count should be correct") {
				suite = TestSuite.new
				suite2 = TestSuite.new
				suite2.add(self.class.new("testSize"))
				suite.add(suite2)
				suite.add(self.class.new("testSize"))
				suite.size == 2
			}
		end
		def testRun
			result = TestResult.new
			progress = 0
			@suite.run(result) {
				progress += 1
			}

			assertBlock("Should have had four test runs") { result.runs == 4 }
			assertBlock("Should have had one test failure") { result.failures == 1 }
			assertBlock("Should have had one test error") { result.errors == 1 }
			assertBlock("Should have had four test progress calls") { progress == 4 }
		end
	end
end
