=begin
=TestCase.rb
Contains TestCase, Lapidarys foundational testing class.
=end

#<standard_header>
#
# Copyright (C) 2000-2001 Nathaniel Talbott
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#</standard_header>

require 'Lapidary/Assertions'
require 'Lapidary/Failure'
require 'Lapidary/Error'
require 'Lapidary/TestSuite'

module Lapidary
	class TestCase
		include Assertions

		def initialize(test)
			if ( method(test).arity != 0 )
				throw :invalidTest
			end
			@test = test
		end
		def TestCase.suite
			methodNames = public_instance_methods(true)
			tests = methodNames.delete_if { |methodName| methodName !~ /test.+/ }
			suite = TestSuite.new()
			tests.each() do
				|test|
				catch :invalidTest do
					suite.add(new(test))
				end
			end
			return suite
		end
		def run(result)
			@_result = result
			begin
				catch :assertionFailed do
					setup()
					send(@test)
				end
			rescue Exception
				addError($!)
			ensure
				begin
					catch :assertionFailed do
						tearDown()
					end
				rescue Exception
					addError($!)
				end
			end
			result.addRun()
		end
		def setup
		end
		def tearDown
		end
		def size
			1
		end
		def addSuccessfulAssertion(message)
			@_result.addSuccessfulAssertion(message)
		end
		def addFailedAssertion(message)
			allLocations = caller()
			allLocations.shift()
			location = allLocations.detect { | entry | entry !~ /Assertions\.rb:/ }
			location = location[/^.+:\d+/]
			@_result.addFailedAssertion(Failure.new("#{name} [#{location}]", message))
		end
		def addError(exception)
			@_result.addError(Error.new(name, exception))
		end
		def name
			"#{@test}(#{self.class.name})"
		end
	end
end
