=begin
=TestRunnerMediator.rb
Works with any given UI to actually run a TestSuite.
=end

#<standard_header>
#
# Copyright (C) 2000-2001 Nathaniel Talbott
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#</standard_header>

require 'Lapidary/UI/Util/Tuner'
require 'Lapidary/TestResult'

module Lapidary
	module UI
		class TestRunnerMediator
			RESET = "TestRunnerMediator::RESET"
			STATUS_CHANGED = "TestRunnerMediator::STATUS_CHANGED"
			RESULT_CHANGED = "TestRunnerMediator::RESULT_CHANGED"
			FAULT_ADDED = "TestRunnerMediator::FAULT_ADDED"
			
			attr_reader(:tuner)

			def initialize(suite)
				@suite = suite.suite()
				@tuner = Util::Tuner.new
			end
			def runSuite
				beginTime = Time.now
				tuner.update(RESET, @suite.size)
				tuner.update(STATUS_CHANGED, Status.new(Status::STARTED_RUNNING, "Started..."))
				result = TestResult.new
				resultListener = proc {
					| updatedResult |
					tuner.update(RESULT_CHANGED, updatedResult)
				}
				result.addResultListener( resultListener )
				faultListener = proc {
					| fault |
					tuner.update(FAULT_ADDED, fault)
				}
				result.addFaultListener( faultListener )
				@suite.run(result) {
					| progress |
					tuner.update(STATUS_CHANGED, Status.new(Status::FINISHED_TEST, progress))
				}
				result.removeFaultListener(faultListener)
				result.removeResultListener(resultListener)
				endTime = Time.now
				elapsedTime = endTime - beginTime
				tuner.update(STATUS_CHANGED, Status.new(Status::FINISHED_RUNNING, "Finished in #{elapsedTime} seconds."))
			end
		end

		class Status
			STARTED_RUNNING = "Status::STARTED_RUNNING"
			FINISHED_TEST = "Status::FINISHED_TEST"
			FINISHED_RUNNING = "Status::FINISHED_RUNNING"
			attr_reader(:type, :message)
			def initialize(type, message)
				@type = type
				@message = message
			end
		end
	end
end
