#!/usr/local/bin/ruby
#$LOAD_PATH.push "../htmltree"
require "dir-compare"
require "doctree"

def dir2tree(dirname, *opts)
  dc = DirCompare.new
  dir = QuasiFile.new(dirname)
  path2elem = {}
  root = Document.new
  now = Time.now
  dc.parse(dir) do |mod, qf|
    next if mod == :out
    if qf.path == "."
      bname = "."
      dname = ""
    else
      bname = File.basename(qf.path)
      dname = File.dirname(qf.path)
    end
    e = if qf.file?
	  attr = {}
	  opts.each do |name|
            case name
	    when "size"
	      attr[name] = qf.size.to_s
	    when "date"
	      attr[name] = qf.mtime.to_s
	    when "time"
	      attr[name] = (qf.mtime).to_i.to_s
	    when "content"
	      attr[name] = open(qf.path){|f| f.read}
	    else
	      $stderr.puts "unkonw option #{name}"
	    end
          end
	  Element.new(bname, attr, true)
	else
	  Element.new(bname)
	end
    path2elem[qf.path] = e
    parent = path2elem[dname]
    if parent
      parent << e
    else
      root << e
    end
  end
  root
end

if $0 == __FILE__
  require "getopts"
  getopts("dtsc")
  dirname = ARGV.shift
  dirname.chomp!("/")
  opts = []
  opts.push "date" if $OPT_d
  opts.push "time" if $OPT_t
  opts.push "size" if $OPT_s
  opts.push "content" if $OPT_c
  dir2tree(dirname).display
end
