#!/usr/bin/ruby -I. -w

require "nqxml/treeparser"
require "nqxml/writer"
require "cps"

b = CPS.new 5
File.open("project.xml") do |source|
	b.time("Parsing file"){
		NQXML::TreeParser.new(source).document
		source.rewind
	}
end
b.time("Document.new") { NQXML::Document.new }
b.time("new element") { NQXML::Tag.new("x", {}) }
document = NQXML::Document.new
element = document.setRoot(NQXML::Tag.new("x", {}))
b.time("add element") { element.addChild( NQXML::Tag.new("x", {})) }
el1 = NQXML::Tag.new("x", {})
puts "add child is same as add element for NQXML"

b.time("Tree manipulation") {
	doc = NQXML::Document.new()
	doc.setRoot(NQXML::Tag.new("tag1", {"blah"=>"four"}))

	tag2 = NQXML::Tag.new( "tag2", {"some"=>"value"})
	node = doc.rootNode.addChild( tag2 )

	tag3 = NQXML::Tag.new( "tag3", {})
	node.addChild( tag3 )
}
File.open("project.xml") do |source|
	document = NQXML::TreeParser.new(source).document
end
b.time("Writing tree") {
	string = ""
	writer = NQXML::Writer.new string
	writer.writeDocument( document )
}
b.time("Detecting children") {
	element = document.rootNode.children.detect{ |node|
		entity = node.entity
		entity.instance_of?(NQXML::Tag) and entity.name == "Datasets"
	}
	element = element.children.detect{ |node|
		entity = node.entity
		entity.instance_of?(NQXML::Tag) and
		entity.name == "link" and
		entity.attrs['idref'] == '18'
	}
}
puts "NQXML does not support XPath searches"
File.open("../documentation.xml") do |source|
	b.time("Parse big") {
		NQXML::TreeParser.new(source).document
		source.rewind
	}
end
