require 'rubyunit'

require 'dpklib/collection'

class TESTCASE_YAEnumerator < RUNIT::TestCase
  def test_proc
    ary = [1,2,3]

    yaenum = Dpklib::YAEnumerator.new do |block|
      ary.each(&block)
    end
    assert_equals ary, yaenum.to_a

    ary2 = [4,5]
    chained_enum = yaenum + ary2
    assert_equals [1,2,3,4,5], chained_enum.to_a
  end

  def test_foreign
    ary = [1,2,3]
    yaenum = Dpklib::YAEnumerator.foreign(ary)
    assert_equals ary, yaenum.to_a
  end
end #/TESTCASE_YAEnumerator

class TESTCASE_EnumerableExtension < RUNIT::TestCase
  def setup
    @src = [4, 7, 9]
  end

  def test_split_at
    src = @src
    lhs, rhs = src.split_at { |i|
      i == 7
    }
    assert_equals [4], lhs
    assert_equals [7, 9], rhs
  end

  def test_cut_until!
    src = @src
    lhs = src.cut_until! { |i|
      i == 9
    }
    assert_equals [4,7], lhs
    assert_equals [9], src
  end
  
  def test_extract!
    src = @src
    ary = src.extract! { |i|
      i == 7
    }
    assert_equals [4,9], src
    assert_equals [7], ary
  end
end #/TESTCASE_EnumerableExtension

class TESTCASE_Collection < RUNIT::TestCase
  def test_array_to_hash
    h = Dpklib.array_to_hash([1, 2, 3, 4]) { |i|
      i.to_s
    }
    assert_equals h["4"], 4
  end

  def test_collect_hash
    hash = { 1 => 2, 3 => 4 }
    newhash = Dpklib.collect_hash(hash) { |key, val|
      case key
      when 1
        [1, 3]
      when 3
        [2, 4]
      end
    }
    assert_equals 3, newhash[1]
    assert_equals 4, newhash[2]
    assert_equals false, newhash.include?(3)
  end

  def test_concurrent_each
    ary1 = [4, 5, 6]
    ary2 = [7, 8]
    ary3 = [10, 11, 12, 13]
    ret = []
    Dpklib.concurrent_each(ary1, ary2, ary3) { |item1, item2, item3|
      ret << [item1, item2, item3]
    }
    assert_equals [[4, 7, 10], [5, 8, 11], [6, nil, 12]], ret
  end

  def test_divide_array
    ary = [1,2,3,4,5,6]
    assert_equals [[1,2,3], [4,5,6]], Dpklib.divide_array_per(ary, 3)
    assert_equals [[1,2,3,4], [5,6]], Dpklib.divide_array_per(ary, 4)
    assert_equals [[1,2,3,4,5,6]], Dpklib.divide_array_per(ary, 99)

    ary = [1,2,3,4]
    assert_equals [[1,2], [3,4]], Dpklib.divide_array_by(ary, 2)
    assert_equals [[1, 2], [3], [4]], Dpklib.divide_array_by(ary, 3)
    assert_equals [[1], [2], [3], [4]], Dpklib.divide_array_by(ary, 5)

    assert_equals [[1,2], [3,4], [5]], Dpklib::divide_array_by([1,2,3,4,5], 3)
    
    assert_equals [[]], Dpklib.divide_array_per([], 1)
    assert_equals [[]], Dpklib.divide_array_by([], 1)
  end

  def test_invert_matrix
    assert_equals [[1, 3], [2, 4]], Dpklib.invert_matrix( [[1,2], [3,4]] , 2, 2 )
    assert_equals [[1, 3], [2, nil]], Dpklib.invert_matrix( [[1,2], [3]] , 2, 2)
    assert_equals [[1, nil], [2, nil]], Dpklib.invert_matrix( [[1,2]] , 2, 2 )
    assert_equals [[1, 3], [nil, 4]], Dpklib.invert_matrix( [[1], [3,4]] , 2, 2 )
  end

  def test_find_index
    ary = %w"a b c"

    assert_equals 1, Dpklib.find_index(ary) { |item|
      item == "b"
    }

    assert_equals nil, Dpklib.find_index(ary) { |item|
      item == "x"
    }
  end

  def test_collect_concat
    result = Dpklib.collect_concat([1, 2, 3]) { |item|
      [item, item]
    }
    assert_equals [1, 1, 2, 2, 3, 3], result
  end
end #/TESTCASE_Collection
