require "dpklib/error"
require "dpklib/unix"

module Dpklib
  InvalidRangeError = Class.new(Exception)
end #/Dpklib

class << Dpklib
  def local_dir(current_script)
    /(.+)\.rb\Z/ =~ current_script
    localdir = File.expand_path($1)
    localdir
  end

  # NOTE: This cause unexpected reload-prevention.
  def local_load(current_script, &block)
    localdir = self.local_dir(current_script)
    $LOAD_PATH.unshift localdir
    begin
      yield localdir
    ensure
      $LOAD_PATH.shift
    end
  end

  def local_require(current_script, loadfile)
    require local_file(loadfile, current_script)
  end

  def local_file(file, current_script)
    localdir = self.local_dir(current_script)
    File.expand_path(file, localdir)
  end
  
  # from auto-reload.rb
  def find_library(lib)
    if lib !~ /\.rb$/
      lib += ".rb"
    end
    for dir in $:
      file = File.expand_path(lib, dir)
      file.untaint
      return file if File.file?(file)
    end
    return nil
  end

  def decimal_integer(int)
    case int
      when nil, String
      unless int && (%r"\A(-|\+|)[0-9]+\z" =~ int) then
        raise(ArgumentError, "invalid value for Integer: #{int.inspect}")
      end
    end
    int.to_i
  end

  def force_range(obj, range)
    range.exclude_end? && raise(InvalidRangeError, range)
    obj = range.first if (range.first > obj)
    obj = range.last if (range.last < obj)
    obj
  end
  
  def safe_eval(level)
    result = nil
    Thread.start {
      $SAFE = level
      result = yield
    }.join
    result
  end

  def protect_eval(expr, &on_error)
    backtrace = caller
    begin
      eval(expr)
    rescue Exception
      error = $!
      # How to cut backtrace correctly!?
      #  error.set_backtrace( error.backtrace[3..-(backtrace.size)] )
      yield(error)
    end
  end

end #/<<Dpklib
