/*
 +     Package: Mingw32-sup
 +     Version: 0.2
 +
 +   File Type: stub function
 +    $RCSfile: getpwent.c,v $ 
 +   $Revision: 1.0 $
 +       $Date: 1998/05/19 18:59:09 $
 +
 + Contributor: Earnie Boyd
 +
 +   Copyright: None.  This file has been placed in the Public Domain.
 +
 +  Warranties: None.  See the file in this package named doc/WARRANTIES.
 +
*/

/*
 * $Log: getpwent.c,v $
 * Revision 1.0  1998/05/19 18:59:09  bcoeeb0
 * Release 1.0
 *
 * Revision 0.3  1998/04/09 18:10:29  bcoeeb0
 * Remove #define __MINGSTUBS__
 * Add #include "pwstubs.h"
 *
 * Revision 0.2  1998/04/03 19:22:08  bcoeeb0
 * Change license to Public Domain.
 *
*/

#include <pwd.h>
#include <stdlib.h>
#include "pwstubs.h"

struct passwd pwent;

struct passwd * getpwent(void)
{
  char *user;
  
  user = getenv("LOGNAME");
  if (!user) user = getenv("USER");
  if (!user) user = getenv("USERNAME");
  if (!user) user = PW_NAME;
  pwent.pw_name     = user;
  pwent.pw_passwd   = PW_PASSWD;
  pwent.pw_uid      = PW_UID;
  pwent.pw_gid      = PW_GID;
  pwent.pw_comment  = PW_COMMENT;
  pwent.pw_gecos    = PW_GECOS;
  pwent.pw_dir      = PW_DIR;
  pwent.pw_shell    = PW_SHELL;
  return &pwent;
}
