# $Id: tc_file.rb,v 1.3 2002/05/04 05:54:40 knu Exp $

require 'test/unit'
begin
  require 'features/ruby18/file'
rescue LoadError; end

class TC_File < Test::Unit::TestCase
  def test_s_extname
    assert_equal("", File.extname(""))
    assert_equal("", File.extname("."))
    assert_equal(".", File.extname(".."))		# XXX: Do we want this?
    assert_equal("", File.extname(".foo"))
    assert_equal(".bar", File.extname(".foo.bar"))	# XXX: Do we want this?
    assert_equal(".", File.extname("foo."))
    assert_equal(".tar", File.extname("foo.tar"))
    assert_equal(".gz", File.extname("foo.tar.gz"))

    assert_equal("", File.extname("/var/tmp/"))
    assert_equal("", File.extname("/var/tmp/."))
    assert_equal(".", File.extname("/var/tmp/.."))
    assert_equal("", File.extname("/var/tmp/.foo"))
    assert_equal(".bar", File.extname("/var/tmp/.foo.bar"))
    assert_equal(".", File.extname("/var/tmp/foo."))
    assert_equal(".tar", File.extname("/var/tmp/foo.tar"))
    assert_equal(".gz", File.extname("/var/tmp/foo.tar.gz"))
  end

  def test_s_fnmatch
    assert_equal(true, File.fnmatch("a*.rb", "abc.rb"))
    assert_equal(false, File.fnmatch("b*.rb", "abc.rb"))

    assert_equal(false, File.fnmatch("a*.rb", "ABC.rb"))
    assert_equal(true, File.fnmatch("a*.rb", "ABC.rb",
				    File::FNM_CASEFOLD))
    assert_equal(true, File.fnmatch("A*.RB", "abc.rb",
				    File::FNM_CASEFOLD))

    assert_equal(true, File.fnmatch("a*.rb", "a/bc.rb"))
    assert_equal(false, File.fnmatch("a*.rb", "a/bc.rb",
				     File::FNM_PATHNAME))
    assert_equal(true, File.fnmatch("a?bc.rb", "a/bc.rb"))
    assert_equal(false, File.fnmatch("a?bc.rb", "a/bc.rb",
				     File::FNM_PATHNAME))
    assert_equal(false, File.fnmatch("b*.rb", "a/bc.rb",
				     File::FNM_PATHNAME))
    assert_equal(true, File.fnmatch("a/b*.rb", "a/bc.rb",
				     File::FNM_PATHNAME))

    assert_equal(true, File.fnmatch("ab\\*.rb", "ab*.rb"))
    assert_equal(false, File.fnmatch("ab\\*.rb", "ab*.rb",
				     File::FNM_NOESCAPE))
    assert_equal(true, File.fnmatch("ab\\\\*.rb", "ab\\c.rb"))
    assert_equal(false, File.fnmatch("ab\\\\*.rb", "ab\\c.rb",
				     File::FNM_NOESCAPE))

    assert_equal(false, File.fnmatch("*", ".irbrc"))
    assert_equal(true, File.fnmatch("*", ".irbrc",
				    File::FNM_DOTMATCH))

    assert_equal(true, File.fnmatch("/home/ruby/?irbrc", "/home/ruby/.irbrc"))
    assert_equal(true, File.fnmatch("/home/ruby/?irbrc", "/home/ruby/.irbrc",
				    File::FNM_DOTMATCH))
    assert_equal(false, File.fnmatch("/home/ruby/?irbrc", "/home/ruby/.irbrc",
				    File::FNM_PATHNAME))
    assert_equal(true, File.fnmatch("/home/ruby/?irbrc", "/home/ruby/.irbrc",
				     File::FNM_DOTMATCH | File::FNM_PATHNAME))
  end

  def test_s_lchmod
    symlink1 = '.unit.test.symlink1'
    symlink2 = '.unit.test.symlink2'

    File.symlink('.unit.test', symlink1)
    File.symlink('.unit.test', symlink2)
    File.lchmod(0614, symlink1, symlink2)
    assert_equal(0614, File.lstat(symlink1).mode & 0777)
    assert_equal(0614, File.lstat(symlink2).mode & 0777)
  rescue NotImplementedError
    # ok
  ensure
    File.unlink(symlink1) rescue nil
    File.unlink(symlink2) rescue nil
  end

  def test_s_lchmod
    symlink1 = '.unit.test.symlink1'
    symlink2 = '.unit.test.symlink2'

    File.symlink('.unit.test', symlink1)
    File.symlink('.unit.test', symlink2)
    File.lchown(0, 1, symlink1, symlink2)
    assert_equal(0, File.lstat(symlink1).uid)
    assert_equal(1, File.lstat(symlink2).gid)
  rescue NotImplementedError, Errno::EPERM
    # ok
  ensure
    File.unlink(symlink1) rescue nil
    File.unlink(symlink2) rescue nil
  end
end

class TC_File_Stat < Test::Unit::TestCase
  def test_rdev
    s = File.stat('/dev/null')

    # XXX: How do we test these?
    assert_kind_of(Integer, s.rdev_major)
    assert_kind_of(Integer, s.rdev_minor)
  rescue Errno::ENOENT
    # ok
  end
end
