# $Id: tc_thread.rb,v 1.1 2002/05/09 21:45:26 nobu Exp $

require 'test/unit'
begin
  require 'features/ruby18/thread'
rescue LoadError; end

class TC_Thread < Test::Unit::TestCase
  def test_join
    start = Time.now
    t = Thread.new do
      sleep 3
    end
    tt = proc do |i|
      s = Time.now
      assert_nil(t.join(i))
      e = Time.now
      assert_equal(true, t.alive?)
      e - s
    end
    tt[0]
    i = tt[1]
    assert(0.5 < i && i < 1.5)
    i = tt[0.5]
    assert(0.4 < i && i < 0.6)
    assert_equal(t, t.join(nil))
    i = Time.now - start
    assert(2.5 < i && i < 3.5)
  ensure
    t.kill
  end
end
