= set.rb

# This library provides the Set class that deals with a collection of
# unordered values with no duplicates.  It is a hybrid of Array's
# intuitive inter-operation facilities and Hash's fast lookup.

ɽ Set 饹󶡤ޤȤϽʣΤʤ֥Ȥ
ŤƤʤޤǤ
Arrayλı黻ǽHashΤ褦ʹ®ʸ碌ޤ

== Example

  require 'set'

  set1 = Set.new ["foo", "bar", "baz", "foo"]

  p set1			#=> #<Set: {"baz", "foo", "bar"}>

  p set1.include?("bar")	#=> true

  set1.add("heh")
  set1.delete("foo")

  p set1			#=> #<Set: {"heh", "baz", "bar"}>

== Set class

# Set implements a collection of unordered values with no duplicates.
# This is a hybrid of Array's intuitive inter-operation facilities and
# Hash's fast lookup.

Set ϽʣΤʤ֥ȤνŤƤʤޤμǤ
Arrayλı黻ǽHashΤ褦ʹ®ʸ碌ޤ

# The equality of each couple of elements is determined according to
# Object#eql? and Object#hash, since Set uses Hash as storage.

2ĤΥ֥Ȥ Object#eql?  Object#hash ˤޤ
ʤʤ顢Set  Hash 򵭲ȤƻȤäƤ뤫Ǥ

=== Included Modules
    Enumerable

=== Class Methods
--- Set::new(enum = nil)
#    Creates a new set containing the elements of the given enumerable
#    object.
     enum Ϳ줿 Enumerable Ǥʤ뤢餷ޤ

--- Set[*ary]
#    Creates a new set containing the given objects.
    Ϳ줿֥Ȥʤ뿷ޤ

=== Instance Methods
--- dup
#    Duplicates the set.
    ʣޤ

--- size
--- length
#    Returns the number of elements.
    ǤθĿ֤ޤ

--- empty?
#    Returns true if the set contains no elements.
    Ǥ1ĤʤȤ true ֤ޤ

--- clear
#    Removes all elements and returns self.
    Ǥ򤹤٤ƺޤ

--- replace(enum)
#    Replaces the contents of the set with the contents of the given
#    enumerable object and returns self.
    Ǥ enum ΤΤ֤ޤǤ򤹤٤ƺenum Ϳ
    줿 Enumerable Ǥ򿷤ǤȤޤ

--- flatten
#    Returns a new set that is a copy of the set, flattening each
#    containing set recursively.
    ͥȤʿ경ƺ뿷֤ޤ

    :

      p s0 = Set[Set[1,2], 3]  #=> #<Set: {#<Set: {1, 2}>, 3}>
      p s0.flatten             #=> #<Set: {1, 2, 3}>
      p s1 = Set[Set[1,2], 1]  #=> #<Set: {#<Set: {1, 2}>, 1}>
      p s1.flatten             #=> #<Set: {1, 2}>

--- flatten!
#    Equivalent to Set#flatten, but replaces the receiver with the
#    result in place.  Returns nil if no modifications were made.
    flatten ƱǤ
    礽켫Ȥʿ경ƺ줿Ǥ֤ޤ
    ǤѹʤäȤˤ nil ֤ޤ

--- to_a
#    Converts the set to an array. (the order is uncertain)
    ѴޤǤ

--- include?(o)
--- member?(o)
#    Returns true if the set contains the given object.
    ֥ o ν° true ֤ޤ

--- superset?(set)
# Returns true if the set is a superset of the given set.
    礬Ϳ줿 set ޤ true ֤ޤ

--- proper_superset?(set)
# Returns true if the set is a proper superset of the given set.
    礬Ϳ줿 set 򿿤˴ޤ true ֤ޤĤޤꡢ
    դĤν礬ˤ false ֤ޤ

--- subset?(set)
# Returns true if the set is a subset of the given set.
    礬Ϳ줿 set ˴ޤޤ true ֤ޤ

--- proper_subset?(set)
# Returns true if the set is a proper subset of the given set.
    礬Ϳ줿 set ˿˴ޤޤ true ֤ޤĤޤꡢ
    դĤν礬ˤ false ֤ޤ

--- each { |o| ... }
#    Calls the given block once for each element in the set, passing
#    the element as parameter.
    Τ٤ƤǤФ1٤ĥ֥å¹Ԥޤ
    ֥åѿ o ˤϤǤϤޤ

--- add(o)
--- << o
#    Adds the given object to the set and returns self.
    ˥֥ o äν缫Ȥ֤ޤ

--- delete(o)
#    Deletes the given object from the set and returns the object.  If
#    the object is not found, returns nil.
    礫饪֥ o ν缫Ȥ֤ޤ
     o °Ƥʤ nil ֤ޤ

--- delete_if { |o| ... }
#    Deletes every element of the set for which block evaluates to
#    true, and returns self.
    ֥åǺǸɾ줿ͤǤ褦ʤ٤ƤǤ
    ν缫Ȥ֤ޤ

--- reject! { |o| ... }
#    Equivalent to Set#delete_if, but returns nil if no changes were
#    made.
    delete_if ƱǤǤ1Ĥʤä nil ֤ޤ

--- merge(enum)
#    Merges the elements of the given enumerable object to the set and
#    returns self.
    enum Ϳ줿 Enumerable Ǥɲäν缫Ȥ֤ޤ

--- subtract(enum)
#    Deletes every element that appears in the given enumerable object
#    and returns self.
    enum Ϳ줿 Enumerable Ǥν缫Ȥ֤ޤ

--- + enum
--- | enum
#    Returns a new set built by merging the set and the elements of the
#    given enumerable object.
    ½硢ʤ2ĤνξʤȤɤ餫°뤹٤
    Ǥʤ뿷ꤽ֤ޤ

--- - enum
#    Returns a new set built by duplicating the set, removing every
#    element that appear in the given enumerable object.
    硢ʤԤ°Ԥ°ʤ٤ƤǤʤ
    ꤽ֤ޤ

--- & enum
#    Returns a new array containing elements common to the set and the
#    given enumerable object.
    ʬʤ2ĤνΤˤ°뤹٤ƤǤʤ
    ꤽ֤ޤ

--- ^ enum
#    Returns a new array containing elements exclusive between the set
#    and the given enumerable object.  (set ^ enum) is equivalent to
#    ((set | enum) - (set & enum)).
    оκʤ2ĤνΤ줫ˤ°뤹٤ƤǤʤ
    ꤽ֤ޤ

--- == set
#    Returns true if two sets are equal.  The equality of each couple
#    of elements is defined according to Object#eql?.
    2Ĥν礬Ȥ true ֤ޤ
    Ǥ Object#eql? Ǹޤ

--- classify { |o| ... }
#    Classifies the set by the return value of the given block and
#    returns a hash of {value => set of elements} pairs.  The block is
#    called once for each element of the set, passing the element as
#    parameter.
    ֥åͤˤäʬषޤ֤ʬ̤ϡ
    { => Ǥν} Ȥ򤷤ϥåǤ
    ֥åϽΤ٤ƤǤФ1٤ļ¹Ԥ졢
    ֥åѿ o ˤϤǤϤޤ

    :

      require 'set'
      files = Set.new(Dir.glob("*.rb"))
      hash = files.classify { |f| File.mtime(f).year }
      p hash    #=> {2000=>#<Set: {"a.rb", "b.rb"}>,
                #    2001=>#<Set: {"c.rb", "d.rb", "e.rb"}>,
                #    2002=>#<Set: {"f.rb"}>}

--- divide { |o| ... }
--- divide { |o1, o2| ... }

#    Divides the set into a set of subsets according to the commonality
#    defined by the given block.

    硢ʤ֥åطʬ䤷̤򽸹Ȥ
    ֤ޤ

#    If the arity of the block is 2, elements o1 and o2 are in common
#    if block.call(o1, o2) is true.  Otherwise, elements o1 and o2 are
#    in common if block.call(o1) == block.call(o2).

    2ĤΤȤ block.call(o1, o2) ʤ o1  o2 Ʊʬ
    °ޤ1ĤΤȤ block.call(o1) == block.call(o2) 
    ʤo1  o2 Ʊʬ°ޤĤޤ֥åΰ2
    ΤȤϥ֥åͤοǷޤƱˡ1ĤΤȤϥ֥
    ͤ == ˤƱʬ䤵ޤ

    2ĤΤȤϡƱʹطΤ
    оΧ(({block.call(o1, o2)})) ʤ (({block.call(o2, o1)}))ס
    ƿΧ(({block.call(o1, o2)}))  
    (({block.call(o2, o3)})) ʤ
    (({block.call(o1, o3)}))
    2ĤȤꤵƤޤ

    :

      require 'set'
      numbers = Set[1, 3, 4, 6, 9, 10, 11]
      set = numbers.divide { |i,j| (i - j).abs == 1 }
      p set     #=> #<Set: {#<Set: {1}>,
                #           #<Set: {11, 9, 10}>,
                #           #<Set: {3, 4}>,
                #           #<Set: {6}>}>

    :

      # 8x2 Υ׾ǥʥȤãǤ֤˴ؤʬ
      require "set"
      board = Set.new
      m, n = 8, 2
      for i in 1..m do for j in 1..n do board << [i,j] end end
      knight_move = Set[1,2]
      p board.divide { |i,j| 
        Set[(i[0]-j[0]).abs, (i[1]-j[1]).abs] == knight_move
      }  #=> #<Set: {#<Set: {[6, 2], [4, 1], [2, 2], [8, 1]}>, 
         #           #<Set: {[2, 1], [8, 2], [6, 1], [4, 2]}>, 
         #           #<Set: {[1, 1], [3, 2], [5, 1], [7, 2]}>, 
         #           #<Set: {[1, 2], [5, 2], [3, 1], [7, 1]}>}>

--- inspect
#    Returns a string containing a human-readable representation of the
#    set. ("#<Set: {element1, element2, ...}>")

    ʹ֤ɤߤ䤹ɽʸ֤ޤ
