= https.rb

SSL/TLS enhancement for Net::HTTP.

== class Net::HTTP

((<"net/http.rb">)) ⻲ȡ

աnet/https.rb  RFC2818  3.1 줿 ֥Сξ˵ܤ줿ȸΥåפ򼫤Ϥʤ³ƤϤΥФΥۥ̾Ⱦ˵ܤƤۥ̾פ뤫饤֥λѼԤƼɬפ롣

((<URL:http://www.ipa.go.jp/security/rfc/RFC2818JA.html#31>))

((<ruby-dev:25254>))

== Example

ñ㡣verify_mode ˻ꤹ˴ؤƤ ((<OpenSSL::SSL>)) 򻲾ȡ
ɬ use_ssl = true ƤФʤФʤȤա

 require 'net/https'
 https = Net::HTTP.new('www.example.com',443)
 https.use_ssl = true
 https.ca_file = '/usr/share/ssl/cert.pem'
 https.verify_mode = OpenSSL::SSL::VERIFY_PEER
 https.verify_depth = 5
 https.start { |w|
   response = w.get('/')
   puts response.body
 }

proxy ͳǥproxy ͳǤ̿ϩϰŹ沽롣((<WWWץˤSSLȥͥ|URL:http://www21.ocn.ne.jp/~k-west/SSLandTLS/draft-luotonen-ssl-tunneling-03-Ja.txt>))򻲾ȡ

 require 'net/https'
 proxy_addr = 'proxy.example.com'
 proxy_port = 3128
 https = Net::HTTP::Proxy(proxy_addr, proxy_port).new('www.example.com',443)
 https.use_ssl = true
 https.ca_file = '/usr/share/ssl/cert.pem'
 https.verify_mode = OpenSSL::SSL::VERIFY_PEER
 https.verify_depth = 5
 https.start {|w|
   response = w.get('/')
   puts response.body
 }

== 󥹥󥹥᥽å

--- use_ssl?
    HTTP  SSL/TLS Ȥʤ true ֤

--- use_ssl=(true_or_false)
    HTTP  SSL/TLS Ȥɤꤹ롣Ȥ true 롣ǥեȤǤ falseĤޤ SSL/TLS ͭˤˤɬ use_ssl = true Ƥɬפ롣

--- peer_cert
    ФäƤ X.509  OpenSSL::X509::Certificate ֥ȤȤ֤

--- key
--- key=(key)
    ((<OpenSSL::PKey::RSA>)) ֥Ȥ ((<OpenSSL::PKey::DSA>)) ֥Ȥꤹ롣
    (This method is appeared in Michal Rokos's OpenSSL extention.)

--- cert
--- cert=(cert)
    饤ȾȤ ((<OpenSSL::X509::Certificate>)) ֥Ȥꤹ롣
    (This method is appeared in Michal Rokos's OpenSSL extention.)

--- ca_file
--- ca_file=(path)
    PEM ¸줿 CA եΥѥꤹ롣
    եˤʣ CA 񤬴ޤޤƤƤɤ

--- ca_path
--- ca_path=(path)
    PEM ¸줿 CA ե뤬¸ߤǥ쥯ȥꤹ롣

--- verify_mode
--- verify_mode=(mode)
    оФ븡ڥ⡼ɤꤹ롣
    OpenSSL::SSL::VERIFY_NONE  OpenSSL::SSL::VERIFY_PEER ǽ
    ((<OpenSSL::SSL>)) ⻲ȡ

--- verify_callback
--- verify_callback=(proc)
    ̾Υоθڤ˲äƤŬѤ
    ((<Proc>)) ֥Ȥꤹ롣

--- verify_depth
--- verify_depth=(num)
    о򸡾ڤξκοꤹ롣

--- cert_store
--- cert_store=(store)
    оθڤΤ˻ȤꤷƤ CA Υȥ졼
    ((<OpenSSL::X509::Store>)) ֥Ȥꤹ롣
    ̾ ca_path=(path)  ca_file=(path) Ȥ
