= CGI::Session
[2001/08/26] by ((<Ӥ|URL:mailto:rubikitch@ruby-lang.org>))

((<URL:http://www.ruby-doc.org/stdlib/libdoc/cgi/rdoc/index.html>))

== 

CGIΥåԤ饤֥ꡣ
åȤϡHTTPΰϢΥꥯȤȥ쥹ݥ󥹤°٤ƥ()
Ȥ򤤤åˤϽ̤ꡢ((<cgi.rb>))󶡤륯åѤƤ
cgi/session.rbѤ狼䤹
åHash饤ʥ󥿡եǤ롣

åϥå ID ȥץबϿå󤫤鹽롣
ǥեȤǤ CGI::Session::FileStore Ѥ졢ϿǤΤʸΤߤǤ롣

å CGI::Session::FileStore  CGI::Session::PStore Ѥ
ФΥե˵Ͽ졢ΥꥯȻѤ롣
ǥեȤǤŪԤʤʤƤץཪλ˥å
ե¸롣å˿ե뤬롣

饤Ȥˤϥåб륻åID򥯥å뤤 form  hidden
inputȤϤȤˤʤ롣åϥǥեȤǤexpiresꤵƤʤ
ˡ֥饦λǾǤ롣

== Ȥ
=== 
  require 'cgi/session'
  cgi = CGI::new
  session = CGI::Session::new( cgi )

((<CGI::Session>))::new((<CGI>))֥ȤϤ饤ȤϤ줿
åIDϥå꡼Ȥ cgi ˳ǼƤ뤿ᡢռɬפϤʤ

=== åϿ
  session['name'] = "rubikitch"

CGI::Session֥ȤHashΤ褦ʤΤǤꡢбͤϿ롣
ǥեȤǤϥץཪλ˥åϥե˵Ͽ롣

=== å롣
  name = session['name']

̤CGIǤΥåФȤϡΤ褦ˤ롣

=== إå
إåϤCGI#outCGI#headerȤäƤ¤ꡢ̤̾ǹʤ
cgi/session.rbŪ˥åѤƤ뤬Υ᥽åɤݤ򸫤ƤΤǡռ򤹤ɬפϤʤ

=== umask
umaskͤ0022ʤХåեΥѡߥå644ˤʤΤǡǤդΥ桼Υåե򸫤뤳ȤǤ롣
줬ʾCGI::Session֥umaskͤꤷƤ

((<ruby 1.8.2 feature>))

ruby 1.8.2 饻åե 0600 Ǻ褦ˤʤä

== class CGI::Session

=== 饹᥽å

--- CGI::Session.new(cgi[, aHash])

    å󥪥֥Ȥ򿷤֤ޤ
    ץȤ ((<Hash>)) ֥ ((|aHash|)) Ϳ뤳ȤǤ롣
    ʲʸ aHash ΥȤǧ롣

      CGI::Session.new(cgi, {"new_session" => true})

    : "session_path"
    
      åpathȤƻȤ. 
      (default: (({File::dirname(ENV["SCRIPT_NAME"])})), 
      ץȤURIpathκǸΥåޤ)
    
    : "session_key"
    
      å<FORM type=hidden>nameȤƻȤ. 
      (default: (({"_session_id"})))
    
    : "session_id"
    
      åIDȤƻȤ. 
      ǥեȤΥǡ١Ǥ(({FileStore}))Ѥ, 
      ͤϱѿʤʸ̵Фʤʤ. 
      Υץ󤬻ꤹȥꥯȤ˥åIDޤޤƤ̵뤵. 
      (default: )
    
    : "new_session"
    
      ͤtrueΤȤ϶Ū˿åϤ. 
    
      ʲ ((<ruby 1.8.2 feature>)) Ǥ
    
      ͤfalseΤȤϡꥯȤ˥åIDޤޤƤʤ
      㳰ArgumentErrorȯ. 
    
      ͤʤȤϡꥯȤ˥åID
      ޤޤƤϤѤޤޤƤʤϿåϤ.
    
      (default: ͤʤ)
      
    : "database_manager"
      
      ǡ١饹. 
      (defalut: (({CGI::Session::FileStore})))
    
       : CGI::Session::FileStore
         ƥȥեȤʸǡʤ
    
       : CGI::Session::MemoryStore
         ΥϥåȤRuby 󥿥ץ꥿¸Τͭ
         ((-mod_rubyѤäƻ...-))
    
       : CGI::Session::PStore
         Marshal եޥåȤȤ뷿Υǡ¸Ǥ롣
         cgi/session/pstore.rb ˤä󶡤뵡ǽΤᡢΥ饤֥ɤ߹ޤʤѤǤʤ
    
    : "tmpdir"
    
      (({CGI::Session::FileStore})) åǡǥ쥯ȥ̾. 
      (default: (({ENV["TMP"] || "/tmp"})))
    
    : "prefix"
    
      (({CGI::Session::FileStore})) åǡΥե̾Ϳץեå. 
      (default: (({""})))
    
    : "suffix"
    
      (({CGI::Session::FileStore})) åǡΥե̾Ϳ륵եå. 
      (default: (({""}))) ((<ruby 1.8.2 feature>))
    
    : "no_hidden"
    
      ((<ɮ罸>))
    
    : "no_cookies"
    
      ((<ɮ罸>))
    
    : "session_expires"
    
      åͭ֡
      ((<Time>))֥ȤͿȡåϤޤ˴줺˻Ĥ롣
      (default: ֥饦νλƱ˴)
    
    : "session_domain"
    
      ((<ɮ罸>))
    
    : "session_secure"
    
      ((<ɮ罸>))
    
    : "session_path"
    
      ((<ɮ罸>))

=== 󥹥󥹥᥽å

--- CGI::Session#[](key)

    ꤵ줿֤ͤޤ

--- CGI::Session#[]=(key, val)

    ꤵ줿ͤꤷޤ

--- CGI::Session#update

    ǡ١饹(({update}))᥽åɤƤӽФơ
    å򥵡Ф¸ޤ

    (({MemoryStore}))ξϲ⤷ޤ

--- CGI::Session#close

    ǡ١饹(({close}))᥽åɤƤӽФơ
    å򥵡Ф¸å󥹥ȥ졼򥯥ޤ((- mod_ruby ʤɤ CGI::Session Ѥ硢Ū close ɬפ롣Ȣ((<URL:http://www.modruby.net/doc/faq.ja.jis.html#label-13>)) -))

--- CGI::Session#delete

    ǡ١饹(({delete}))᥽åɤƤӽФơ
    å򥹥ȥ졼ޤ

    (({FileStore}))ξϥåեޤ
    åեŪ˺ʤлĤäƤޤ

== class CGI::Session::FileStore
== class CGI::Session::MemoryStore
== class CGI::Session::PStore
((<ɮ罸>))

== CGI::HtmlExtension#form ν

(({CGI::Session.new}))(({CGI::HtmlExtension#form}))ϡåIDեɤưϤ褦ˤʤޤ(({CGI::Session.new}))ϡˤä줿եեͤ򡢥åIDȤƼưǧޤ

(({CGI::HtmlExtension#form}))Ȥ(({<INPUT TYPE="submit">}))ǥڡܤ򤹤褦ˤСåȤʤĶǤΥåݻѤǤޤ

  #!/usr/bin/ruby
  require 'cgi'
  require 'cgi/session'
  
  cgi = CGI::new('html3')
  File.umask(0066)
  session = CGI::Session::new(cgi)
  cgi.out('charset'=>'euc-jp') {
    html = cgi.html {
      cgi.head { cgi.title {'form Demo'} }
      cgi.body {
        cgi.form('action'=>"#{cgi.script_name}") {
          cgi.p {
            'ʤ̾ϡ' +
            cgi.text_field('name') +
            cgi.hidden('cmd', 'hello') +
            cgi.submit('Ǥ')
          }
        }
      }
    }
    CGI.pretty(html)
  }
  #=>
  <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
  <HTML>
    <BODY>
      <FORM METHOD="post" ENCTYPE="application/x-www-form-urlencoded" action="/sample.rb">
        <P>
          ʤ̾ϡ
          <INPUT NAME="name" SIZE="40" TYPE="text">
          <INPUT NAME="cmd" TYPE="hidden" VALUE="hello">
          <INPUT TYPE="submit" VALUE="Ǥ">
        </P>
        <INPUT TYPE="HIDDEN" NAME="_session_id" VALUE="bc315cc069266e21">    # 
      </FORM>
    </BODY>
  </HTML>

== 
̾ϤȤĤ򤹤ΤĤޤʤCGI

ǥ((<|URL:http://www.ruby-lang.org/~rubikitch/session-demo/>))

=== 
  #!/usr/bin/ruby
  require 'kconv'
  require 'cgi'
  require 'cgi/session'
  
  class SessionDemo
    def initialize
      @cgi = CGI::new
      File.umask(0066)                                # åեïˤɤޤ줿ʤ
      @session = CGI::Session::new( @cgi )            # åϤ롣
      @cmd = "#{@cgi['cmd'].first}"                   # ruby 1.8 Ǥư褦(warning ϽФޤ)
      @cmd = 'start' if @cmd.empty?
      @header = { "type" => "text/html", "charset" => "euc-jp" }
  
      __send__("cmd_#{@cmd}")
    end
    
    def cmd_start
      @cgi.out( @header ) {
        <<-END
        <html><head><title>CGI::Session Demo</title></head>
        <body>
         <form action="#{ENV['SCRIPT_NAME']}" method="get">
         <p>
         ʤ̾ϡ
         <input type="text" name="name">
         <input type="hidden" name="cmd" value="hello">
         <input type="submit" value="Ǥ">
         </p>
         </form>
        </body></html>
        END
      }
    end
  
    def cmd_hello
      name = Kconv::toeuc( @cgi['name'].first )
      @session['name'] = name                         # å˵
      @cgi.out( @header ) {                           # åϱ쥯åݻ뤿ᡢCGI#outǽ
        <<-END
        <html><head><title>CGI::Session Demo</title></head>
        <body>
         <p>ˤϡ#{name}</p>
         <p><a href="#{ENV['SCRIPT_NAME']}?cmd=bye">[]</a></p>
        </body></html>
        END
      }
    end
  
    def cmd_bye
      name = @session['name']                         # åǡФ
      @cgi.out( @header ) {
        <<-END
        <html><head><title>CGI::Session Demo</title></head>
        <body>
         <p>#{name}󡢤褦ʤ</p>
         <p><a href="#{ENV['SCRIPT_NAME']}">[]</a></p>
        </body></html>
        END
      }
    end
  end
  
  SessionDemo.new

== URL
* ((<URL:http://www.shugo.net/article/webdb2/#label:13>))
* ((<URL:http://www.modruby.net/doc/faq.ja.jis.html#label-13>))
