= GDBM

GDBMファイルをアクセスするクラス．キー，データともに文字列でなければな
らないという制限と，データがファイルに保存されるという点を除いては
Hashクラスと全く同様に扱うことがでます．

== スーパークラス:

* ((<Object>))

== インクルードしているモジュール: 

* ((<Enumerable>))

== クラスメソッド:

--- new(dbname[, mode[, flags]])
--- open(dbname[, mode[, flags]])
--- open(dbname[, mode[, flags]]) {|db| ...}
    ((|dbname|))で指定したデータベースをモードを
    ((|mode|))に設定してオープンします．((|mode|))の省
    略値は0666です．((|mode|))として(({nil}))を指定
    するとデータベースが存在しない時には新たなデータベースを作らず
    (({nil}))を返します．

    ((|flags|)) には，GDBM::FAST, GDBM::SYNC, GDBM::NOLOCK を
    の論理和を指定します．デフォルト値は指定なし(つまり0)です．

    Ruby 1.8.2 以降では、flags に
    GDBM::READER, GDBM::WRITER, GDBM::WRCREAT, GDBM::NEWDB
    のどれかを与えて読み書きのモードを指定できます。
    これらをどれも指定しなかった場合には、
    GDBM::WRCREAT, GDBM::WRITER, GDBM::READER の順で試します。

    ブロックを指定した場合，オープンしたGDBMオブジェクトを
    引数にブロックを実行します．実行後GDBMオブジェクトをクローズ
    し，openメソッドはブロックの結果を返します．これはちょうど
    以下と同じです．

      dbm = GDBM.open(file)
      begin
        yield dbm
      ensure
        dbm.close
      end

== メソッド:

--- self[key]
    ((|key|))をキーとする値を返します．

--- self[key]=value
    ((|key|))をキーとして，((|value|))を格納します．

--- cachesize = size

--- clear
    DBMファイルを空にします．

--- close
    DBMファイルをクローズします．以後の操作は例外を発生させます．

--- delete(key)
--- delete(key) {|key| ... }
    ((|key|))をキーとする項目を削除します．

    指定したキーが存在しなければnilを返します，このとき
    ブロックを指定していれば，ブロックを評価します．

--- delete_if { |key, value|  ...  }
--- reject! { |key, value|  ...  }
    ブロックを評価した値が真であれば該当する項目を削除します．

--- each {|key, value|  ...  }
--- each_pair {|key, value|  ...  }
    各要素に対するイテレータ．

--- each_key {|key|  ...  }
    全てのkeyに対して繰り返すイテレータ．

--- each_value {|value|  ...  }
    全てのvalueに対して繰り返すイテレータ．

--- empty?
    データベースが空の時，真を返します．

--- fastmode = bool
--- syncmode = bool
    オープンしているGDBMオブジェクトのモードを変更します．下記の定数
    GDBM::FAST、GDBM::SYNC を参照してください．

--- fetch(key[,ifnone])
--- fetch(key) {|key| ... }
    ハッシュと同じ

--- has_key?(key)
--- key?(key)
--- include?(key)
--- member?(key)
    keyがデータベース中に存在する時，真を返します．

--- has_value?(key)
--- value?(value)
    valueを値とする組がデータベース中に存在する時，真を返します．

--- index(val)
    ハッシュと同じ

--- indexes(key_1, ... )  ((<obsolete>))
--- indices(key_1, ... )  ((<obsolete>))
    各引数の値をキーとする要素を含む配列を返します．

--- invert
    値からキーへのハッシュを返します．

--- keys
    データベース中に存在するキー全てを含む配列を返します．

--- length
--- size
    データベース中の要素の数を返します．(注意:現在の実現では要素数を数
    えるためにデータベースを全部検索します)

--- reject {|key, value| ... }
    ((<self.to_hash.reject|Hash>)) と同じです．ハッシュを返します．

--- reorganize
    GDBMでは，要素の削除を行ってもDBファイルのサイズは減少しません(削
    除によって空いた領域は次の格納のために取っておかれます、)．このメ
    ソッドを呼び出すことでDBMファイルを新規に作り直し無駄な領域をなく
    すことができます．

    大量の削除を行ったときに，ディスクスペースの節約のために使用します．

--- replace(other)
    DBMの内容を ((|other|)) の内容で置き換えます．
    ((|other|)) は each_pair メソッドを持つオブジェクトで
    なければなりません．

--- shift
    データベース中の要素を一つ取り出し，データベースから削除します．

--- store(key, val)
    self[key]=val と同じです．((|key|))に対して((|val|))を格納します．

--- sync
    要素の変更をファイルに反映します．FASTモード
    (GDBM#open() の第3引数にGDBM::FAST を指定)のときだけ意味があります．

    注) GNU gdbm version 1.8 以降よりFASTモードがデフォルトになりました．

--- to_a
    DBMの各要素を格納した配列を返します．返される配列の1つの要素は 
    [key, val] です．(つまり配列の配列を返します)．

--- to_hash
    DBMの各要素を格納したハッシュを返します．

--- update(other)
    DBMと((|other|))の内容をマージします．重複するキーに対応する値は
    ((|other|))の内容で上書きされます．

    ((|other|))は each_pair メソッドを持つオブジェクトでなければなりま
    せん．

--- values
    データベース中に存在する値全てを含む配列を返します．

== 定数

--- GDBM::VERSION
    libgdbm のバージョン情報の文字列です．

以下の定数は open の第3引数に指定します．

--- GDBM::FAST
    書き込みの結果が，ディスク上のファイルにすぐに反映しなくなります．
    このモードのときに結果を明示的にファイルに反映させるには GDBM#sync 
    メソッドを呼びます．libgdbm version 1.8.0 以降ではこのモードがデフォルト
    です．

--- GDBM::SYNC
    書き込みの結果が，ディスク上のファイルにすぐに反映されます．
    libgdbm version 1.8.0 以前のデフォルトモードです．

    この定数は libgdbm version 1.8.0 以降より有効です

--- GDBM::NOLOCK
    通常，他のプロセスがDBをオープンしている最中にオープンを行うと
    Errno::EWOULDBLOCK(またはErrno::EAGAIN)例外が発生します．このフラグを
    指定していれば，他のプロセスがオープンしている最中でも同時オープンする
    ことができます．

    この定数は libgdbm version 1.8.0 以降より有効です．

--- GDBM::READER ((<ruby 1.8.2 feature>))
    読み込みモードでオープンします．
--- GDBM::WRITER ((<ruby 1.8.2 feature>))
    書き込みモードでオープンします．
--- GDBM::WRCREAT ((<ruby 1.8.2 feature>))
    書き込みモードで、すでにファイルが存在しなかったら作ります．
--- GDBM::NEWDB ((<ruby 1.8.2 feature>))
    書き込みモードで、すでにファイルが存在したら削除してから作り直します．
