= openssl.rb

((<OpenSSL|URL:http://www.openssl.org>)) support library for Ruby.	

((<執筆者募集>))

== Components

* ((<OpenSSL>))
* OpenSSL::Cipher
  * ((<OpenSSL::Cipher::Cipher>))
  * 以下のクラスは Cipher を継承している。使い方は Chipher を参照。
  * OpenSSL::Cipher::BF
  * OpenSSL::Cipher::DES
  * OpenSSL::Cipher::RC2
  * OpenSSL::Cipher::RC4
  * OpenSSL::Cipher::RC5
* OpenSSL::Digest
  * ((<OpenSSL::Digest::Digest>))
  * 以下のクラスは Digest を継承している。使い方は Digest を参照。
  * OpenSSL::Digest::DSS1
  * OpenSSL::Digest::MD2
  * OpenSSL::Digest::MD4
  * OpenSSL::Digest::MD5
  * OpenSSL::Digest::MDC2
  * OpenSSL::Digest::RIPEMD160
  * OpenSSL::Digest::SHA
  * OpenSSL::Digest::SHA1
* OpenSSL::X509
  * ((<OpenSSL::X509::Certificate>))
  * ((<OpenSSL::X509::CRL>))
  * ((<OpenSSL::X509::Extension>))
  * ((<OpenSSL::X509::Name>))
  * ((<OpenSSL::X509::Store>))
  * ((<OpenSSL::X509::StoreContext>))
* ((<OpenSSL::SSL>))
  *((<OpenSSL::SSL::SSLContext>))
  *((<OpenSSL::SSL::SSLServer>))
  *((<OpenSSL::SSL::SSLSocket>))
* ((<OpenSSL::PKCS7>))
  * ((<OpenSSL::PKCS7::PKCS7>))
* OpenSSL::PKey
  * ((<OpenSSL::PKey::PKey>))
  * ((<OpenSSL::PKey::RSA>))
  * ((<OpenSSL::PKey::DSA>))
  * ((<OpenSSL::PKey::DH>))
* OpenSSL::Config
* OpenSSL::Engine
* ((<OpenSSL::ASN1>))
  * ((<OpenSSL::ASN1::ASN1Data>))
    * ((<OpenSSL::ASN1::Primitive>))
      * OpenSSL::ASN1::Boolean
      * OpenSSL::ASN1::Integer
      * OpenSSL::ASN1::Enumerated
      * OpenSSL::ASN1::BitString
      * OpenSSL::ASN1::OctetString
      * OpenSSL::ASN1::UTF8String
      * OpenSSL::ASN1::NumericString
      * OpenSSL::ASN1::PrintableString
      * OpenSSL::ASN1::T61String
      * OpenSSL::ASN1::VideotexString
      * OpenSSL::ASN1::IA5String
      * OpenSSL::ASN1::GraphicString
      * OpenSSL::ASN1::ISO64String
      * OpenSSL::ASN1::GeneralString
      * OpenSSL::ASN1::UniversalString
      * OpenSSL::ASN1::BMPString
      * OpenSSL::ASN1::Null
      * ((<OpenSSL::ASN1::ObjectId>))
      * OpenSSL::ASN1::UTCTime
      * OpenSSL::ASN1::GeneralizedTime
    * ((<OpenSSL::ASN1::Constructive>))
      * OpenSSL::ASN1::Sequence
      * OpenSSL::ASN1::Set

== 例

自己署名証明書の作成。自分の秘密鍵で自分の公開鍵に署名しているから自己署名。

  require 'openssl'
  
  key = OpenSSL::PKey::RSA.new(1024)
  digest = OpenSSL::Digest::SHA1.new()
  
  issu = sub = OpenSSL::X509::Name.new()
  sub.add_entry('C', 'JP')
  sub.add_entry('ST', 'Shimane')
  sub.add_entry('CN', 'Ruby Taro')
  
  cer = OpenSSL::X509::Certificate.new()
  cer.not_before = Time.at(0)
  cer.not_after = Time.at(0)
  cer.public_key = key  # <= 署名する対象となる公開鍵 
  cer.serial = 1
  cer.issuer = issu
  cer.subject = sub
  
  cer.sign(key, digest) # <= 署名するのに使う秘密鍵とハッシュ関数
  print cer.to_text
