= time.rb
組み込みの ((<Time>)) クラスを拡張します。日時を表す文字列をパースして ((<Time>)) オブジェクトに変換したり、逆に ((<Time>)) オブジェクトを RFC などで定められた文字列に変換したりする機能を提供します。

* date-time は ((<RFC:2822>)) で定義されています。
* HTTP-date は ((<RFC:2616>)) で定義されています。
* dateTime は XML Schema Part 2: Datatypes (ISO 8601) で定義されています。
* 文字列から((<Time>))オブジェクトへの変換では((<ParseDate>))により様々な形式を扱えます。

== Design Issue
((<"ruby-src:lib/time.rb">))参照
((<執筆者募集>))

== クラスメソッド:
--- Time.parse(date, now=Time.now)
--- Time.parse(date, now=Time.now) {|year| year}

    ((|date|))を((<ParseDate.parsedate|ParseDate/ParseDate.parsedate>))によって
    パースして((<Time>))オブジェクトに変換します。

    ブロック付きで呼ばれた場合、((|date|))の年はブロックによって変換されます。

    例:
        Time.parse(...) {|y| y < 100 ? (y >= 69 ? y + 1900 : y + 2000) : y}

    与えられた時刻に上位の要素がなかったり壊れていた場合、((|now|))の
    該当要素が使われます。
    下位の要素がなかったり壊れていた場合、最小値(1か0)が使われます。

    例:
        # 現在時刻が "Thu Nov 29 14:33:20 GMT 2001" で
        # タイムゾーンがGMTとすると:
        Time.parse("16:30")     #=> Thu Nov 29 16:30:00 GMT 2001
        Time.parse("7/23")      #=> Mon Jul 23 00:00:00 GMT 2001
        Time.parse("2002/1")    #=> Tue Jan 01 00:00:00 GMT 2002

    ((-((<執筆者募集>))-))

    ((<ParseDate>))が((|date|))から情報を取り出せないとき、または
    ((<Time>))クラスが指定された日時を表現できないときに((<ArgumentError>))が
    発生します。

    このメソッドは他のパース用メソッドのフェイルセーフとして以下のように使用できます:
      Time.rfc2822(date) rescue Time.parse(date)
      Time.httpdate(date) rescue Time.parse(date)
      Time.xmlschema(date) rescue Time.parse(date)

    従って((<Time.parse|time.rb/Time.parse>))の失敗はチェックすべきです。

--- Time.rfc2822(date)
--- Time.rfc822(date)
    ((<RFC:2822>))で定義されているdate-timeとして((|date|))をパースして
    ((<Time>))オブジェクトに変換します。
    この形式は((<RFC:822>))で定義されて((<RFC:1123>))で更新された形式と
    同じです。

    ((|date|))が((<RFC:2822>))に準拠していない、または
    ((<Time>))クラスが指定された日時を表現できないときに((<ArgumentError>))が
    発生します。

--- Time.httpdate(date)
    ((<RFC:2616>))で定義されているHTTP-dateとして((|date|))をパースして
    ((<Time>))オブジェクトに変換します。

    ((|date|))が((<RFC:2616>))に準拠していない、または
    ((<Time>))クラスが指定された日時を表現できないときに((<ArgumentError>))が
    発生します。
--- Time.xmlschema(date)
--- Time.iso8601(date)
    XML Schema で定義されているdateTimeとして((|date|))をパースして
    ((<Time>))オブジェクトに変換します。

    ((|date|))がISO 8601で定義されている形式に準拠していない、または
    ((<Time>))クラスが指定された日時を表現できないときに((<ArgumentError>))が
    発生します。

== メソッド:
--- Time#rfc2822
--- Time#rfc822
    ((<RFC:2822>))で定義されているdate-timeとして表現される以下の形式の文字列を返します:

      day-of-week, DD month-name CCYY hh:mm:ss zone

    ただし zoneは [+-]hhmm です。

    selfがUTC timeの場合、zoneは +0000 になります。

--- Time#httpdate
    ((<RFC:2616>))で定義されているHTTP-dateのrfc1123-dateとして
    表現される以下の形式の文字列を返します:

      day-of-week, DD month-name CCYY hh:mm:ss GMT

    注意: 結果はいつも UTC (GMT) です。

--- Time#xmlschema([fractional_seconds])
--- Time#iso8601([fractional_seconds])
    XML Schemaで定義されているdateTimeとして
    表現される以下の形式の文字列を返します:

      CCYY-MM-DDThh:mm:ssTZD
      CCYY-MM-DDThh:mm:ss.sssTZD

    ただし TZD は Z または [+-]hh:mm です。

    If self is a UTC time, Z is used as TZD.
    [+-]hh:mm is used otherwise.

    ((|fractional_seconds|))は小数点以下の秒を指定します。
    ((|fractional_seconds|))のデフォルト値は0です。
