= webrick/ssl.rb

((<執筆者募集>))

((<WEBrick::GenericServer>)) を SSL/TLS に対応させるための実装。
このファイルを require すると WEBrick::GenericServer が SSL/TLS 対応になる。

ruby 1.8.3 以降では単に require するだけでは SSL/TLS は有効ではなく、
設定で明示的にを有効にする必要がある。

== WEBrick::GenericServer クラス

((<WEBrick::GenericServer>)) も参照。

== クラスメソッド

--- GenericServer.new(config={}, default=WEBrick::Config::General)
    config で有効な項目が増える。以下は増える項目とそのデフォルト値。
   
      #
      :ServerSoftware       => "#{svrsoft} OpenSSL/#{osslv}",
      :SSLEnable            => true, # ruby 1.8.3 以降では false がデフォルトです。
      :SSLCertificate       => nil,
      :SSLPrivateKey        => nil,
      :SSLClientCA          => nil,
      :SSLExtraChainCert    => nil,
      :SSLCACertificateFile => nil,
      :SSLCACertificatePath => nil,
      :SSLCertificateStore  => nil,
      :SSLVerifyClient      => ::OpenSSL::SSL::VERIFY_NONE,
      :SSLVerifyDepth       => nil,
      :SSLVerifyCallback    => nil,   # custom verification
      :SSLTimeout           => nil,
      :SSLOptions           => nil,
      :SSLStartImmediately  => true,
      # Must specify if you use auto generated certificate.
      :SSLCertName          => nil,
      :SSLCertComment       => "Generated by Ruby/OpenSSL"

== メソッド

--- ssl_context
    サーバが保持する ((<OpenSSL::SSL::SSLContext>)) オブジェクトを返す。

== WEBrick::Config::General

以下のほとんどの項目はサーバが保持する ((<OpenSSL::SSL::SSLContext>)) オブジェクト
を設定するためのものです。詳しくは ((<OpenSSL::SSL::SSLContext>)) を参照して下さい。

: :ServerSoftware
   サーバソフト名を設定する。デフォルトでは 
   "WEBrick/VERSION (Ruby/VERSION/RELEASE_DATE) OpenSSL/VERSION"。

: :SSLEnable
   ssl を有効にするかどうかを設定する。
   ruby 1.8.2 まではデフォルトで true。ruby 1.8.3 以降はデフォルトで false。

: :SSLCertificate
   サーバ証明書を設定します。((<OpenSSL::X509::Certificate>)) オブジェクトです。
   nil の場合、WEBrick は自己署名証明書を自動的に生成する。

: :SSLPrivateKey
   サーバの秘密鍵を設定します。((<OpenSSL::PKey::PKey>)) の
   サブクラスのインスタンスです。

: :SSLClientCA
   サーバがクライアント証明書を要求する時にクライアントに送る CA のリスト。
   ((<OpenSSL::SSL::SSLContext#client_ca|OpenSSL::SSL::SSLContext/client_ca>)) 
   を参照。

: :SSLExtraChainCert
   証明書チェーン。所有している証明書からルート CA までの証明書のリスト。
   ((<OpenSSL::SSL::SSLContext#extra_chain_cert|OpenSSL::SSL::SSLContext/extra_chain_cert>))
   を参照。

: :SSLCACertificateFile

: :SSLCACertificatePath

: :SSLCertificateStore

: :SSLVerifyClient

: :SSLVerifyDepth

: :SSLVerifyCallback

: :SSLTimeout

: :SSLOptions

: :SSLStartImmediately

: :SSLCertName
   自己署名証明書を作成する場合の証明書の CN を文字列で設定する。

: :SSLCertComment
   自己署名証明書を作成する場合の拡張領域の nsComment の値。
   デフォルトでは "Generated by Ruby/OpenSSL"。
