= Date

日付を扱うクラスです。((-この文書のオリジナル (の html 版) は、
((<URL:http://www.funaba.org/date2/manual.html>)),
((<URL:http://www.funaba.org/en/date2/manual.html>)) 
です-))

: ((<DateTime>))
  日付だけでなく時間も扱える Date のサブクラスです。

== 用語の定義

いくつか用語の定義は、ISO 8601、および JIS X 0301 に基づきます。

=== 暦日付

暦日付は、暦年、暦月、および暦月の中の序数によって
指定される特定の日の日付です。

つまり、ごく当たり前の年月日による日付です。

=== 年間通算日 (年日付)

年間通算日 (年日付) は、暦年、および暦年の中の序数によって指定される
特定の日の日付です。

=== 暦週日付

暦週日付は、暦週と暦年中の序数による日付です。

暦週は、暦年中の序数によって指定される特定の7日の期間であり、月曜から
始まります。その年の第1暦週は、最初の木曜日を含む週とします。これは、1
月4日を含む週と同じです。

=== ユリウス日

ユリウス日は紀元前4713年1月1日 (ユリウス暦) 正午 (グリニッジ平均時) を
暦元とした通日 (経過日数) です。

この文書で、天文学的なユリウス日とは、本来のユリウス日と同じものです。
また、年代学的なユリウス日とは、地方時における零時を一日の始まりとする
流儀です。

この文書で、単に「ユリウス日」といった場合、それは本来のユリウス日でな
く、「年代学的なユリウス日」を意味しています。

=== 修正ユリウス日

修正ユリウス日は西暦1858年11月17日 (グレゴリオ暦) 零時 (協定世界時) を
暦元とした通日 (経過日数) です。

この文書で、天文学的な修正ユリウス日とは、本来の修正ユリウス日と同じも
のです。また、年代学的な修正ユリウス日とは、地方時における零時を一日の
始まりとする流儀です。

この文書で、単に「修正ユリウス日」といった場合、それは本来の修正ユリウ
ス日でなく、「年代学的な修正ユリウス日」を意味しています。


== 使い方

  require 'date'

== スーパークラス

((<Object>))

== インクルードしているモジュール

((<Comparable>))

== 定数

--- MONTHNAMES
    月の名称(January, February ... )

    MONTHNAMES[0] == nil で MONTHNAMES[1] == "January" です。

--- DAYNAMES
    曜日の名称(Sunday, Monday ... )

    DAYNAMES[0] == "Sunday" です。

--- ABBR_MONTHNAMES
    月の省略名(Jan, Feb ... )

    ABBR_MONTHNAMES[0] == nil で ABBR_MONTHNAMES[1] == "Jan" です。

--- ABBR_DAYNAMES
    曜日の省略名(Sun, Mon ... )

    ABBR_DAYNAMES[0] == "Sun" です。

== クラスメソッド

--- civil([year[, mon[, mday[, start]]]])
--- new([year[, mon[, mday[, start]]]])
    暦日付に相当する日付オブジェクトを生成します。

    このクラスでは、紀元前の年を天文学の流儀で勘定します。
    1年の前は零年、零年の前は-1年、のようにします。
    月、および月の日は負、
    または正の数でなければなりません (負のときは最後からの序数)。
    零であってはなりません。

    最後の引数は、グレゴリオ暦をつかい始めた日をあらわすユリウス日です。
    グレゴリオ暦の指定として真、ユリウス暦の指定として偽を与えることもできます。
    省略した場合は、Date::ITALY (1582年10月15日) になります。

    jd も参照してください。

--- commercial([cwyear[, cweek[, cwday[, start]]]])
    暦週日付に相当する日付オブジェクトを生成します。

    週、および週の日 (曜日) は負、
    または正の数でなければなりません(負のときは最後からの序数)。
    零であってはなりません。

    このメソッドに改暦前の日付を与えることはできません。

    jd、および new も参照してください。

--- jd([jd[, start]])
    ユリウス日に相当する日付オブジェクトを生成します。

    このクラスのいくつかの重要なメソッドで、
    負のユリウス日は保証されません。

    new も参照してください。

--- ordinal([year[, yday[, start]]])
    年間通算日 (年日付) に相当する日付オブジェクトを生成します。

    月の日は負、
    または正の数でなければなりません (負のときは最後からの序数)。
    零であってはなりません。

    jd、および new も参照してください。

--- parse(str[, complete[, start]])
    与えられた日付表現を解析し、
    その情報に基づいて日付オブジェクトを生成します。

    省略できる最後の引数が真で、年が0から99の範囲であれば、
    年の下2桁表現であるとみなしこれを補います。
    なお、省略した場合は、偽とみなします。

    _parse も利用できます。
    このメソッドは parse と似ていますが、日付オブジェクトを生成せずに、
    見いだした要素をハッシュで返します。

--- strptime(str[, format[, start]])
    与えられた雛型で日付表現を解析し、
    その情報に基づいて日付オブジェクトを生成します。

    _strptime も利用できます。
    このメソッドは strptime と似ていますが、日付オブジェクト生成せずに、
    見いだした要素をハッシュで返します。

    strptime(3)、および strftime も参照してください。

--- today([start])
    現在の日付に相当する日付オブジェクトを生成します。

--- valid_civil? (year, mon, mday[, start])
--- valid_date? (year, mon, mday[, start])
    正しい暦日付であれば、相当するユリウス日を返します。
    そうでないなら、偽を返します。

    jd、および civil も参照してください。

--- valid_commercial? (cwyear, cweek, cwday[, start])
    正しい暦週日付であれば、相当するユリウス日を返します。
    そうでないなら、偽を返します。

    jd、および commercial も参照してください。

--- valid_jd? (jd[, start])
    ひとつ目の引数をそのまま返します。

    対称性のため用意されていますが、実際的に意味はありません。

    jd も参照してください。

--- valid_ordinal? (year, yday[, start])
    正しい年間通算日 (年日付) であれば、相当するユリウス日を返します。
    そうでないなら、偽を返します。

    jd、および ordinal も参照してください。

== メソッド

--- self + n
    self から n 日後の日付オブジェクトを返します。
    n は数値でなければなりません。

--- self - x
    x が日付オブジェクトなら、ふたつの差を返します。
    あるいは
    x が数値ならば、self より x 日前の日付を返します。

--- self << n
    self より n ヶ月前の日付オブジェクトを返します。
    n は数値でなければなりません。

--- self <=> other
    ふたつを比較し、-1、零、あるいは 1 を返します。
    other は日付オブジェクトか、
    天文学的なユリウス日をあらわす数値でなければなりません。

--- self === other
    同じ日なら真を返します。

--- self >> n
    self から n ヶ月後の日付オブジェクトを返します。
    n は数値でなければなりません。

--- asctime
--- ctime
    asctime(3) 書式の文字列を返します (ただし、末尾の "\n\0" は除く)。

--- cwday
    暦週の日 (曜日) を返します (1-7、月曜は1)。

--- cweek
    暦週を返します (1-53)。

--- cwyear
    暦週における年を返します。

--- downto(min){|date| ...}
    このメソッドは、(({step(min, -1){|date| ...}})) と等価です。

--- england
    このメソッドは、(({new_start(Date::ENGLAND)})) と等価です。

--- gregorian
    このメソッドは、(({new_start(Date::GREGORIAN)})) と等価です。

--- italy
    このメソッドは、(({new_start(Date::ITALY)})) と等価です。

--- jd
    ユリウス日を返します。
    時刻を含みません。

    ajd も利用できます。
    このメソッドは jd と似ていますが、天文学的なユリウス日を返します。
    時刻を含みます。

--- julian
    このメソッドは、(({new_start(Date::JULIAN)})) と等価です。

--- leap?
    閏年なら真を返します。

--- mday
--- day
    月の日を返します (1-31)。

--- mjd
    修正ユリウス日を返します。
    時刻の情報を含みません。

    amjd も利用できます。
    このメソッドは mjd と似ていますが、天文学的な修正ユリウス日を返します。
    時刻を含みます。

--- mon
--- month
    月を返します (1-12)。

--- new_start([start])
    self を複製して、その改暦日を設定しなおします。
    引数を省略した場合は、Date::ITALY (1582年10月15日) になります。

    new も参照してください。

--- start
    改暦日をあらわすユリウス日を返します。

    new も参照してください。

--- step(limit, step){|date| ...}
    ブロックの評価を繰り返します。ブロックは日付オブジェクトをとります。
    limit は日付オブジェクトでなければなりません、
    また step は非零でなければなりません。

--- strftime([format])
    与えられた雛型で日付を書式づけます。
    つぎの変換仕様をあつかいます:

    %A, %a, %B, %b, %C, %c, %D, %d, %e, %F, %G, %g, %H, %h, %I, %j, %k, %l,
    %M, %m, %n, %P, %p, %R, %r, %S, %s, %T, %t, %U, %u, %V, %v, %W, %w, %X,
    %x, %Y, %y, %Z, %z, %%, %+

    strftime(3)、および strptime も参照してください。

--- succ
--- next
    翌日の日付オブジェクトを返します。

--- to_s
    ISO 8601 書式の文字列を返します (拡大表記はつかいません)。

--- upto(max){|date| ...}
    このメソッドは、(({step(max, 1){|date| ...}})) と等価です。

--- wday
    曜日を返します (0-6、日曜日は零)。

--- yday
    年の日を返します (1-366)。

--- year
    年を返します。
