= Zlib::ZStream

((<zlib.so>))

圧縮データを扱うストリームを表す抽象クラス。
具体的な圧縮/展開の操作は、それぞれサブクラスの ((<Zlib::Deflate>)),
((<Zlib::Inflate>)) で定義されています。

Zlib::ZStream オブジェクトは、ストリーム (struct zstream) の
入力側 (next_in) と出力側 (next_out) にそれぞれ可変長の
バッファを持ちます。以下、入力側のバッファを「入力バッファ」、
出力側のバッファを「出力バッファ」と呼びます。

Zlib::ZStream オブジェクトに入力されたデータは、一旦入力バッファの
末尾にストアされた後、ストリームからの出力がなくなるまで
(処理後 avail_out > 0 となるまで) 入力バッファの先頭から順に処理されます。
処理の間、出力バッファは全出力を保持するために必要に応じて自動的に
確保・拡張されます。

いくつかのメソッドは、出力バッファ内のデータを取り出し、
String オブジェクトとして返します。

以上を図示すると次のようになります:

     +================ an instance of Zlib::ZStream ================+
     ||                                                            ||
     ||     +--------+          +-------+          +--------+      ||
     ||  +--| output |<---------|zstream|<---------| input  |<--+  ||
     ||  |  | buffer |  next_out+-------+next_in   | buffer |   |  ||
     ||  |  +--------+                             +--------+   |  ||
     ||  |                                                      |  ||
     +===|======================================================|===+
         |                                                      |
         v                                                      |
     "output data"                                         "input data"

入力バッファの内容を処理している最中にエラーが発生した場合、
((<Zlib::Error>)) のサブクラスの例外が発生します。その時、
入力/出力バッファは共に、エラーが発生した時点の状態をそのまま
保持します。

== スーパークラス

* Object

== クラスメソッド:

--- ZStream.new

    ((<Zlib::Deflate.new|Zlib::Deflate/Deflate.new>)) 及び ((<Zlib::Inflate.new|Zlib::Inflate/Inflate.new>)) を参照。

== メソッド:

--- avail_in

    入力バッファに溜っているデータのバイト数を返します。通常は 0 です。

--- avail_out

    出力バッファの空き用量をバイト数で返します。
    空きは必要な時に動的に確保されるため、通常は 0 です。

--- avail_out = size

    出力側のバッファに ((|size|)) バイトの空きを確保します。
    すでに ((|size|)) バイト以上の空きがある場合、バッファは
    縮められます。空きは必要な時に動的に確保されるため、通常
    このメソッドを使う必要はありません。

--- flush_next_in

    入力バッファに残っているデータを強制的に取り出します。

--- flush_next_out

    出力バッファに残っているデータを強制的に取り出します。

--- total_in

    ストリームに入力されたデータの総バイト数を返します。

--- total_out

    ストリームの出力したデータの総バイト数を返します。

--- data_type

    ストリームに入力されたデータの形式を推測します。
    返り値は Zlib::BINARY, Zlib::ASCII, Zlib::UNKNOWN の
    いずれかです。

--- adler

    alder-32 チェックサムを返します。

--- reset

    ストリームの状態をリセットします。
    入力/出力バッファ内に残っていたデータは破棄されます。

--- finish

    ストリームへの入力を終了し、出力バッファをフラッシュします。
    より具体的な振る舞いは ((<Zlib::Deflate#finish|Zlib::Deflate/finish>)),
    ((<Zlib::Inflate#finish|Zlib::Inflate/finish>)) を参照して下さい。

--- finished?
--- stream_end?

    ストリームへの入力が終了している時に真を返します。

--- close
--- end

    ストリームを閉じます。
    以後、このストリームにアクセスすることはできなくなります。

--- closed?
--- ended?

    ストリームが閉じられている時に真を返します。
