= irb.rb

Author: Keiju ISHITSUKA

*((<irb.rb/irbとは?>))
*((<irb.rb/起動>))
*((<irb.rb/使い方>))
*((<irb.rb/コマンドオプション>))
*((<irb.rb/コンフィギュレーション>))
*((<irb.rb/コマンド>))
*((<irb.rb/システム変数>))
*((<irb.rb/履歴の保存>))
*((<irb.rb/使用例>))
*((<irb.rb/使用上の制限>))
* irb 関連ライブラリ
  *((<irb.rb/xmp.rb>))
  *((<irb.rb/frame.rb>))
  *((<irb.rb/completion.rb>))

== irbとは?

irbはinteractive rubyの略です. rubyの式を標準入力から簡単に入力/実行する
ためのツールです.

== 起動

  % irb

で行ないます. 

== 使い方

irbの使い方は, Rubyさえ知っていればいたって簡単です. 基本的には irb と
いうコマンドを実行するだけです. irbを実行すると, 以下のようなプロンプ
トが表れてきます. 後は, rubyの式を入れて下さい. 式が完結した時点で実行
されます.

  dim% irb
  irb(main):001:0> 1+2
  3
  irb(main):002:0> class Foo
  irb(main):003:1>  def foo
  irb(main):004:2>    print 1
  irb(main):005:2>  end
  irb(main):006:1> end
  nil
  irb(main):007:0> 

また, irb は ((<Readline>)) モジュールにも対応しています. ((<Readline>)) モジュールが
インストールされている時には, それを使うのが標準の動作になります.

== コマンドオプション

  irb.rb [options] file_name opts
  options:
  -f                ~/.irbrc を読み込まない.
  -m                bcモード(分数, 行列の計算ができる)
  -d                $DEBUG をtrueにする(ruby -d と同じ)
  -Kc               ruby -Kcと同じ
  -r load-module    ruby -r と同じ.
  -I                ruby -I と同じ. ((<ruby 1.8.2 feature>))
  --verbose         これから実行する行を表示する(デフォルト)
  --noverbose       これから実行する行を表示しない
  --echo            実行結果を表示する(デフォルト)
  --noecho          実行結果を表示しない
  --inspect         結果出力にinspectを用いる(bcモード以外はデフォルト). 
  --noinspect       結果出力にinspectを用いない.
  --readline        readlineライブラリを利用する.
  --noreadline      readlineライブラリを利用しない. デフォルトの動作は,
                    inf-ruby-mode以外でreadlineライブラリを利用しよう
                    とする. 
  --prompt prompt-mode
  --prompt-mode prompt-mode
                    プロンプトモードを切替えます. 現在定義されているプ
                    ロンプトモードは, default, simple, xmp, inf-rubyが
                    用意されています. デフォルトはdefaultプロンプトモー
                    ドになっています.
                            
  --inf-ruby-mode   emacsのinf-ruby-mode用のプロンプト表示を行なう. 特
                    に指定がない限り, readlineライブラリは使わなくなる.
  --simple-prompt
                    非常にシンプルなプロンプトを用いるモードです.
  --noprompt        プロンプト表示を行なわない.
  --tracer          コマンド実行時にトレースを行なう.
  --back-trace-limit n
                    バックトレース表示をバックトレースの頭から n, 後ろ
                    からnだけ行なう. デフォルトは16 
  --irb_debug n     irbのデバッグデバッグレベルをnに設定する(利用しな
                    い方が無難でしょう).
  -v, --version     irbのバージョンを表示する

== コンフィギュレーション

irb 起動時に ~/.irbrc を読み込みます. もし存在しない場合は,
カレントディレクトリの .irbrc,  irb.rc , _irbrc, $irbrc の load を順に試みます.

オプションを設定する代わりに, 以下のコマンドでもデフォルトの動作を設定
できます.

  IRB.conf[:AUTO_INDENT] = false
  IRB.conf[:BACK_TRACE_LIMIT]=16
  IRB.conf[:DEBUG_LEVEL]=1
  IRB.conf[:ECHO] = nil
  IRB.conf[:EVAL_HISTORY] = nil
  IRB.conf[:HISTORY_FILE] = nil ((<ruby 1.9 feature>))
  IRB.conf[:IGNORE_EOF] = false
  IRB.conf[:IGNORE_EOF]=false
  IRB.conf[:IGNORE_SIGINT] = true
  IRB.conf[:IGNORE_SIGINT]=true
  IRB.conf[:INSPECT_MODE]=nil
  IRB.conf[:IRB_NAME]="irb"
  IRB.conf[:IRB_RC] = nil
  IRB.conf[:MATH_MODE]=false
  IRB.conf[:PROMPT] = {...}
  IRB.conf[:PROMPT_MODE] = :DEFALUT
  IRB.conf[:SINGLE_IRB] = false
  IRB.conf[:SAVE_HISTORY] = nil  ((<ruby 1.9 feature>))
  IRB.conf[:USE_LOADER] = false
  IRB.conf[:USE_LOADER]=false
  IRB.conf[:USE_READLINE] = nil
  IRB.conf[:USE_TRACER] = false
  IRB.conf[:USE_TRACER]=false
  IRB.conf[:VERBOSE]=true

=== プロンプトの設定

プロンプトをカスタマイズしたい時には, 

   IRB.conf[:PROMPT]

を用います. 例えば, .irbrc の中で下のような式を記述します:

   IRB.conf[:PROMPT][:MY_PROMPT] = { # プロンプトモードの名前
     :PROMPT_I => nil,                  # 通常のプロンプト
     :PROMPT_S => nil,                  # 文字列などの継続行のプロンプト
     :PROMPT_C => nil,                  # 式が継続している時のプロンプト
     :RETURN => "    ==>%s\n"          # リターン時のプロンプト
   }

プロンプトモードを指定したい時には,

  irb --prompt my-prompt

でそのプロンプトモードで起動されます. または, .irbrc に下式を記述しても
OKです.

  IRB.conf[:PROMPT_MODE] = :MY_PROMPT

PROMPT_I, PROMPT_S, PROMPT_Cは, フォーマットを指定します.

  %N        起動しているコマンド名が出力される.
  %m        mainオブジェクト(self)がto_sで出力される.
  %M        mainオブジェクト(self)がinspectされて出力される.
  %l        文字列中のタイプを表す(", ', /, ], `]'は%wの中の時)
  %NNi        インデントのレベルを表す. NNは数字が入りprintfの%NNdと同じ. 省
        略可能
  %NNn        行番号を表します.
  %%    %

例えば, デフォルトのプロンプトモードは:

  IRB.conf[:PROMPT_MODE][:DEFAULT] = {
      :PROMPT_I => "%N(%m):%03n:%i> ",
      :PROMPT_S => "%N(%m):%03n:%i%l ",
      :PROMPT_C => "%N(%m):%03n:%i* ",
      :RETURN => "%s\n"
  } 

となっています. :DEFAULT の他に、:NULL, :CLASSIC, :SIMPLE, :XMP が定義されています。
((<"ruby-src:lib/irb/init.rb">))

RETURNは, 現在のところprintf形式です. 将来仕様が変わるかも知れません.

=== サブirbの設定

コマンドラインオプションおよび (({IRB.conf})) は(サブ)irb起動時のデフォルトの
設定を決めるもので, ((<"irb.rb/コマンド"|irb.rb/コマンド>)) にある conf で
個別の(サブ)irbの設定ができるようになっています.

(({IRB.conf[:IRB_RC]})) に ((|proc|)) が設定されていると, サブirbを起動する時にその
proc を irb のコンテキストを引数として呼び出します. これによって個別のサ
ブirbごとに設定を変えることができるようになります.

== コマンド

irb拡張コマンドは, 簡単な名前と頭に`irb_'をつけた名前と両方定義されて
います. これは, 簡単な名前がoverrideされた時のためです.

--- exit
--- quit
--- irb_exit        
    終了する. 
    サブirbの場合, そのサブirbを終了する.

--- conf
--- irb_context
    irbの現在の設定を表示する. 設定の変更は, confにメッセージを送るこ
    とによって行なえる. 

--- conf.eval_history = N
    実行結果のヒストリ機能の設定.
    nnは整数かnilで nn>0 であればその数だけヒストリにためる。nn==0の時は
    無制限に記憶する、nilだとヒストリ機能はやめる(デフォルト). 

--- Conf.back_trace_limit
    バックトレース表示をバックトレースの頭からn, 後ろからnだけ行なう.
    デフォルトは16
    
--- conf.debug_level = N
    irb用のデバッグレベルの設定

--- conf.ignore_eof = true/false
    ^Dが入力された時の動作を設定する. trueの時は^Dを無視する, falseの
    時はirbを終了する. 

--- conf.ignore_sigint= true/false
    ^Cが入力された時の動作を設定する. false時は, irbを終了する. trueの
    時の動作は以下のようになる:
      入力中: これまで入力したものをキャンセルしトップレベルに戻る. 
      実行中: 実行を中止する.

--- conf.inf_ruby_mode = true/false
    inf-ruby-mode用のプロンプト表示を行なう. デフォルトはfalse.

--- conf.inspect_mode = true/false/nil
    インスペクトモードを設定する.
      true: インスペクトして表示する.
      false: 通常のprintで表示する.
      nil: 通常モードであれば, inspect modeとなり, mathモードの時は, non inspect modeとなる.   

--- conf.math_mode
    参照のみ. bcモード(分数, 行列の計算ができます)かどうか?

--- conf.use_loader = true/false
    load/require時にirbのfile読み込み機能を用いるモードのスイッチ(デフォ
    ルトは用いない). このモードはIRB全体に反映される.

--- conf.prompt_c
    ifの直後など, 行が継続している時のプロンプト.

--- conf.prompt_i
    通常のプロンプト.

--- conf.prompt_s
    文字列中などを表すプロンプト.

--- conf.rc
    ~/.irbrcを読み込んだかどうか?

--- conf.use_prompt = true/false
    プロンプト表示するかどうか? デフォルトではプロンプトを表示する.

--- conf.use_readline = true/false/nil
    readlineを使うかどうか?
      true: readlineを使う.
      false: readlineを使わない.
      nil: (デフォルト)inf-ruby-mode以外でreadlineライブラリを利用しようとする.  
#
#--- conf.verbose=T/F
#    irbからいろいろなメッセージを出力するか?

--- cws([obj])
--- chws([obj])
--- irb_cws([obj])
--- irb_chws([obj])
--- irb_change_workspace([obj])
    objをselfとする. objが省略されたときは, home workspace, すなわち
    irbを起動したときのmain objectをselfとする.

--- pushws([obj])
--- irb_pushws([obj])
--- irb_push_workspace([obj])
    UNIXシェルコマンドのpushdと同様.

--- popws
--- irb_popws
--- irb_pop_workspace
    UNIXシェルコマンドのpopdと同様.

--- irb [obj]
    サブirbを立ちあげる. objが指定された時は, そのobjをselfとする.

--- jobs
--- irb_jobs
    サブirbのリスト

--- fg n
--- irb_fg n
    指定したサブirbにスイッチする. nは, 次のものを指定する.

      irb番号
      スレッド
      irbオブジェクト
      self(irb objで起動した時のobj)

--- kill n
--- irb_kill n
      サブirbをkillする. nはfgと同じ.

--- souce path
--- irb_source  path
    UNIXシェルコマンドのsourceと似ている. 現在の環境上でpath内のスクリ
    プトを評価する.

--- irb_load path, prev

    Rubyのloadのirb版.

== システム変数


--- _  
    前の計算の実行結果を覚えている(ローカル変数).

      $ irb
      irb(main):001:0> 10
      => 10
      irb(main):002:0> 2**32
      => 4294967296
      irb(main):003:0> _
      => 4294967296
      irb(main):004:0> _ - 2**31
      => 2147483648
      irb(main):005:0> 

--- __ 
    実行結果の履歴を覚えている.
    __[line_no] で、その行で実行した結果を得ることができる. line_no が負の
    時には、最新の結果から -line_no 前の結果を得ることができる.

    デフォルトでは使えません。
    使用するには、IRB.conf[:EVAL_HISTORY] = 100 などと ~/.irbrc で
    設定しておく必要があります。

      $ irb
      irb(main):001:0> conf.eval_history = 100
      => 100
      irb(main):002:0> 1 + 2
      => 3
      irb(main):003:0> 'hoge' + 'foo'
      => "hogefoo"
      irb(main):004:0> __[2]
      => 3
      irb(main):005:0> __[3]
      => "hogefoo"
      irb(main):006:0> __[-1]
      => "hogefoo"
      irb(main):007:0> 

== 履歴の保存

((<ruby 1.9 feature>))
((- 1.8.2 に入っていない理由は ((<ruby-dev:25595>)) を参照してください。 -))

設定ファイルに 

  IRB.conf[:SAVE_HISTORY] = 100

などと書いておくとヒストリーファイルにコマンドの履歴が記録されます。ヒストリーファイルはデフォルトでは ~/.irb_history です。ヒストリーファイルは IRB.conf[:HISTORY_FILE] で設定することができます。

==  使用例

以下のような感じです.

  dim% ruby irb.rb
  irb(main):001:0> irb                        # サブirbの立ちあげ
  irb#1(main):001:0> jobs                     # サブirbのリスト
  #0->irb on main (#<Thread:0x400fb7e4> : stop)
  #1->irb#1 on main (#<Thread:0x40125d64> : running)
  nil
  irb#1(main):002:0> fg 0                     # jobのスイッチ
  nil
  irb(main):002:0> class Foo;end
  nil
  irb(main):003:0> irb Foo                    # Fooをコンテキストしてirb
                                              # 立ちあげ
  irb#2(Foo):001:0> def foo                   # Foo#fooの定義
  irb#2(Foo):002:1>   print 1
  irb#2(Foo):003:1> end
  nil
  irb#2(Foo):004:0> fg 0                      # jobをスイッチ
  nil
  irb(main):004:0> jobs                       # jobのリスト
  #0->irb on main (#<Thread:0x400fb7e4> : running)
  #1->irb#1 on main (#<Thread:0x40125d64> : stop)
  #2->irb#2 on Foo (#<Thread:0x4011d54c> : stop)
  nil
  irb(main):005:0> Foo.instance_methods       # Foo#fooがちゃんと定義さ
                                              # れている
  ["foo"]
  irb(main):006:0> fg 2                       # jobをスイッチ
  nil
  irb#2(Foo):005:0> def bar                   # Foo#barを定義
  irb#2(Foo):006:1>  print "bar"
  irb#2(Foo):007:1> end
  nil
  irb#2(Foo):010:0>  Foo.instance_methods
  ["bar", "foo"]
  irb#2(Foo):011:0> fg 0                      
  nil
  irb(main):007:0> f = Foo.new
  #<Foo:0x4010af3c>
  irb(main):008:0> irb f                      # Fooのインスタンスでirbを
                                              # 立ちあげる.
  irb#3(#<Foo:0x4010af3c>):001:0> jobs
  #0->irb on main (#<Thread:0x400fb7e4> : stop)
  #1->irb#1 on main (#<Thread:0x40125d64> : stop)
  #2->irb#2 on Foo (#<Thread:0x4011d54c> : stop)
  #3->irb#3 on #<Foo:0x4010af3c> (#<Thread:0x4010a1e0> : running)
  nil
  irb#3(#<Foo:0x4010af3c>):002:0> foo         # f.fooの実行
  nil
  irb#3(#<Foo:0x4010af3c>):003:0> bar         # f.barの実行
  barnil
  irb#3(#<Foo:0x4010af3c>):004:0> kill 1, 2, 3# jobのkill
  nil
  irb(main):009:0> jobs
  #0->irb on main (#<Thread:0x400fb7e4> : running)
  nil
  irb(main):010:0> exit                       # 終了
  dim% 

== 使用上の制限

irbは, 評価できる時点(式が閉じた時点)での逐次実行を行ないます. したがっ
て, rubyを直接使った時と, 若干異なる動作を行なう場合があります.

現在明らかになっている問題点を説明します.

=== ローカル変数の宣言

rubyでは, 以下のプログラムはエラーになります.

  eval "foo = 0"
  foo
  --
  -:2: undefined local variable or method `foo' for #<Object:0x40283118> (NameError)
  ---
  NameError

ところが, irbを用いると

  >> eval "foo = 0"
  => 0
  >> foo
  => 0

となり, エラーを起こしません. これは, rubyが最初にスクリプト全体をコン
パイルしてローカル変数を決定するからです. それに対し, irbは実行可能に
なる(式が閉じる)と自動的に評価しているからです. 上記の例では, 

  evel "foo = 0" 

を行なった時点で評価を行ない, その時点で変数が定義されるため, 次式で 
変数fooは定義されているからです.

このようなrubyとirbの動作の違いを解決したい場合は, begin...endで括って
バッチ的に実行して下さい:

  >> begin
  ?>   eval "foo = 0"
  >>   foo
  >> end
  NameError: undefined local variable or method `foo' for #<Object:0x4013d0f0>
  (irb):3
  (irb_local_binding):1:in `eval'

=== ヒアドキュメント

現在のところヒアドキュメントの実装は不完全です. 

=== シンボル

シンボルであるかどうかの判断を間違えることがあります. 具体的には式が完了
しているのに継続行と見なすことがあります.

== xmp.rb

ごとけんxmpの上位互換バージョンです. ただ, 非常に重いのでごとけんxmpで
は対応できない時に, 使用すると良いでしょう.

=== 使い方

==== 関数として使う.

    require "irb/xmp"
    xmp <<END
    foo = 1
    foo
    END
    ---
    foo = 1
        ==>1
    foo
        ==>1

==== XMPインスタンスを用いる.

この場合は, XMPがコンテキスト情報を持つので, 変数の値などを保持してい
ます.

  require "irb/xmp"
  xmp = XMP.new
  xmp.puts <<END
  foo = 1
  foo
  END
  xmp.puts <<END
  foo
  END
  ===
  foo = 1
      ==>1
  foo
      ==>1
  foo
      ==>1

=== コンテキストに関して

XMPメソッド群のコンテキストは, 呼び出す前のコンテキストで評価されます.
明示的にコンテキストを指定するとそのコンテキストで評価します.

例:

  xmp "foo", an_binding

:注:
マルチスレッドには対応していません.

== frame.rb
現在実行中のフレーム情報を取り扱うためのクラスです. 

* IRB::Frame.top(n = 0)
  上からn番目のコンテキストを取り出します. nは0が最上位になります.
* IRB::Frame.bottom(n = 0)
  下からn番目のコンテキストを取り出します. nは0が最下位になります.
* IRB::Frame.sender
  センダになっているオブジェクトを取り出します. センダとは, そのメソッ
  ドを呼び出した側のselfのことです.

:注:
set_trace_funcを用いてRubyの実行をトレースしています. マルチスレッドに
は対応していません.

== completion.rb
irbのcompletion機能を提供するものです. 

=== 使い方

   % irb -r irb/completion

とするか, ~/.irbrc 中に

   require "irb/completion"

を入れてください. irb実行中に require "irb/completion" してもよいです.

irb実行中に (TAB) を押すとコンプレーションします.

トップレベルで(TAB)を押すとすべての構文要素, クラス, メソッドの候補がで
ます. 候補が唯一ならば完全に補完します.

  irb(main):001:0> in    
  in                    inspect               instance_eval
  include               install_alias_method  instance_of?
  initialize            install_aliases       instance_variables
  irb(main):001:0> inspect
  "main"
  irb(main):002:0> foo = Object.new
  #<Object:0x4027146c>

((|変数名.|))の後に(TAB)を押すと, そのオブジェクトのメソッド一覧がでま
す.

  irb(main):003:0> foo.
  foo.==                  foo.frozen?             foo.protected_methods
  foo.===                 foo.hash                foo.public_methods
  foo.=~                  foo.id                  foo.respond_to?
  foo.__id__              foo.inspect             foo.send
  foo.__send__            foo.instance_eval       foo.singleton_methods
  foo.class               foo.instance_of?        foo.taint
  foo.clone               foo.instance_variables  foo.tainted?
  foo.display             foo.is_a?               foo.to_a
  foo.dup                 foo.kind_of?            foo.to_s
  foo.eql?                foo.method              foo.type
  foo.equal?              foo.methods             foo.untaint
  foo.extend              foo.nil?                
  foo.freeze              foo.private_methods     
