= Time

時刻オブジェクト。((<Time/Time.now>)) は現在の時刻を返します。
((<File#stat|File/stat>)) の返すファイルのタイムスタンプは (({Time})) 
オブジェクトです。

(({Time})) オブジェクトは時刻を起算時からの経過秒数で保持しています。
起算時は協定世界時(UTC、もしくはその旧称から GMT とも表記されます) の
1970年1月1日午前0時です。なお、うるう秒を勘定するかどうかはシステムに
よります。

現在の Unix システムでの最大時刻は、
協定世界時の2038年1月19日午前3時14分7秒
です。
# ENV["TZ"]=""; p Time.at(0x7fffffff) # => Tue Jan 19 03:14:07 UTC 2038

また、(({Time})) オブジェクトは協定世界時と地方時のどちらのタイムゾー
ンを使用するかのフラグを内部に保持しています。ただし、この情報は 
((<Marshal/Marshal.dump>)) では保存されず、((<Marshal/Marshal.load>)) 
で読み込んだ (({Time})) オブジェクトのタイムゾーンは常に地方時になりま
す。

    p Marshal.load(Marshal.dump(Time.now.gmtime)).zone
    # => "JST"

((<ruby 1.9 feature>)): 1.9 以降、タイムゾーンのフラグは Marshal デー
タに保持されます。

    p Marshal.load(Marshal.dump(Time.now.gmtime)).zone
    # => "UTC"

== スーパークラス:

* ((<Object>))

== インクルードしているモジュール:

* ((<Comparable>))

== クラスメソッド:

--- Time.at(time[, usec])

    ((|time|)) で指定した時刻の (({Time})) オブジェクトを返します。
    ((|time|)) は (({Time})) オブジェクト、もしくは起算時からの経過秒
    数を表わす整数か浮動小数点数です。

    浮動小数点の精度では不十分な場合、((|usec|)) を指定します。
    (({((|time|)) + (((|usec|))/1000000)})) の時刻を返します。この場合、
    ((|time|))、((|usec|)) ともに整数でなければなりません。

    生成された (({Time})) オブジェクトのタイムゾーンは地方時となります。

--- Time.gm(year[, mon[, day[, hour[, min[, sec[, usec]]]]]])
--- Time.gm(sec, min, hour, mday, mon, year, wday, yday, isdst, zone)
--- Time.utc(year[, mon[, day[, hour[, min[, sec[, usec]]]]]])
--- Time.utc(sec, min, hour, mday, mon, year, wday, yday, isdst, zone)

    引数で指定した協定世界時の (({Time})) オブジェクトを返します。第 2 
    引数以降は省略可能で、省略した場合の値はその引数がとり得る最小の値
    です。

    数値を受け付ける引数には文字列も指定できます。

        p Time.gm *"2002-03-17".split("-")
        # => Sun Mar 17 00:00:00 UTC 2002

    ((|mon|)) は 1(1月)から 12(12月)の範囲の整数または文字列です。英語
    の月名("Jan", "Feb", ... などの省略名。文字の大小は無視)も指定でき
    ます。

    引数の数が((<Time#to_a|Time/to_a>)) と全く同じ場合(こちらは秒が先
    頭に来る形式ですが)、その順序を正しく解釈します。
    この形式の引数 ((|wday|)), ((|yday|)), ((|zone|)) に指定した値は無
    視されます。
    ((|isdst|)) には夏時間(Daylight Saving Time (Summer Time))があるか
    を真偽値で指定します。

--- Time.local(year[, mon[, day[, hour[, min[, sec[, usec]]]]]])
--- Time.local(sec, min, hour, mday, mon, year, wday, yday, isdst, zone)
--- Time.mktime(year[, mon[, day[, hour[, min[, sec[, usec]]]]]])
--- Time.mktime(sec, min, hour, mday, mon, year, wday, yday, isdst, zone)

    引数で指定した地方時の (({Time})) オブジェクトを返します。引数の扱
    いは ((<Time/Time.gm>)) と同じです。

--- Time.new
--- Time.now

    現在時刻の (({Time})) オブジェクトを返します。(({new})) は 
    (({now})) とは (({initialize})) を呼び出す点が異なります。

--- Time.times  ((<obsolete>))

    自身のプロセスとその子プロセスが消費したユーザ/システム CPU 
    時間の積算を ((<Struct>))::Tms のオブジェクトとして返します。
    (({Struct::Tms})) は以下のメンバを持つ構造体クラスです。

      utime           # user time
      stime           # system time
      cutime          # user time of children
      cstime          # system time of children

    時間の単位は秒で、浮動小数点数で与えられます。詳細は 
    ((<times(3)|manual page>)) を参照してください。

    ((<ruby 1.7 feature>))
    このメソッドは ((<Process>)) に移動しました。Time.times も使えます
    が、警告メッセージが出力されます。

== メソッド:

--- self + other

    (({self})) より ((|other|)) 秒だけ後の時刻を返します

--- self - other

    ((|other|)) が (({Time})) オブジェクトである時、ふたつの時刻の差を 
    ((<Float>)) で返します。単位は秒です。((|other|)) が数値である時には ((|self|)) 
    より ((|other|)) 秒だけ前の時刻を返します。

--- self <=> other

    時刻の比較。((|other|)) は (({Time})) オブジェクトか数値でなければ
    なりません。数値の場合は起算時からの経過秒数とみなして比較します。

--- asctime
--- ctime

    時刻を ((<asctime(3)|manual page>)) の形式の文字列に変換します。た
    だし、末尾の \n は含まれません。

--- gmt?
--- utc?

    (({self})) のタイムゾーンが協定世界時に設定されていれば真を返しま
    す。

--- getgm
--- getutc

    ((<ruby 1.7 feature>))

    タイムゾーンを協定世界時に設定した (({Time})) オブジェクトを新しく
    生成して返します。

--- getlocal

    ((<ruby 1.7 feature>))

    タイムゾーンを地方時に設定した (({Time})) オブジェクトを新しく生成
    して返します。

--- gmtime
--- utc

    タイムゾーンを協定世界時に設定します。(({self})) を返します。

    このメソッドを呼び出した後は時刻変換を協定世界時として行ないます。
    協定世界時を表示するためには以下のようにします。

      print Time.now.gmtime, "\n"

    ((<Time/localtime>)), ((<Time/gmtime>))の挙動はシステムの
    ((<localtime(3)|manual page>))の挙動に依存します。(({Time})) クラ
    スでは時刻を起算時からの経過秒数として保持していますが、ある特定の
    時刻までの経過秒は、システムがうるう秒を勘定するかどうかによって異
    なる場合があります。システムを越えて (({Time})) オブジェクトを受け
    渡す場合には注意する必要があります。

--- localtime

    タイムゾーンを地方時に設定します(デフォルト)。(({self})) を返しま
    す。

    このメソッドを呼び出した後は時刻変換を協定地方時として行ないます。

    ((<Time/localtime>)), ((<Time/gmtime>))の挙動はシステムの
    ((<localtime(3)|manual page>))の挙動に依存します。(({Time})) クラ
    スでは時刻を起算時からの経過秒数として保持していますが、ある特定の
    時刻までの経過秒は、システムがうるう秒を勘定するかどうかによって異
    なる場合があります。システムを越えて (({Time})) オブジェクトを受け
    渡す場合には注意する必要があります。

--- strftime(format)

    時刻を ((|format|)) 文字列に従って文字列に変換した結果を返します。
    ((|format|)) 文字列として指定できるものは 以下の通りです。

    * (({%A})): 曜日の名称(Sunday, Monday ... )
    * (({%a})): 曜日の省略名(Sun, Mon ... )
    * (({%B})): 月の名称(January, February ... )
    * (({%b})): 月の省略名(Jan, Feb ... )
    * (({%c})): 日付と時刻
    * (({%d})): 日(01-31)
    * (({%H})): 24時間制の時(00-23)
    * (({%I})): 12時間制の時(01-12)
    * (({%j})): 年中の通算日(001-366)
    * (({%M})): 分(00-59)
    * (({%m})): 月を表す数字(01-12)
    * (({%p})): 午前または午後(AM,PM)
    * (({%S})): 秒(00-60) (60はうるう秒)
    * (({%U})): 週を表す数。最初の日曜日が第1週の始まり(00-53)
    * (({%W})): 週を表す数。最初の月曜日が第1週の始まり(00-53)
    * (({%w})): 曜日を表す数。日曜日が0(0-6)
    * (({%X})): 時刻
    * (({%x})): 日付
    * (({%Y})): 西暦を表す数
    * (({%y})): 西暦の下2桁(00-99)
    * (({%Z})): タイムゾーン  ((<trap|trap::Time>))
    * (({%%})): %自身

    現在の実装では、このメソッドは、システムの ((<strftime(3)|manual page>)) 
    をそのまま使用しています。そのためここにあげた指示子以外のものが使
    用できる場合があります。ただし、上記以外の指示子を使用した場合、移
    植性をそこなう可能性がある点に注意してください。

--- sec
--- min
--- hour
--- mday
--- day         (mday の別名)
--- mon
--- month       (mon の別名)
--- year
--- wday
--- yday
--- isdst
--- dst?        (isdst の別名)
--- zone

    時刻の要素を返します。

    * hour, min, sec: 時、分、秒を整数で返します。
    * year, month(mon), day(mday): 年、月、日を整数で返します。
    * wday: 曜日を0(日曜日)から6(土曜日)の整数で返します。
    * yday: 1月1日を1とした通算日(1から366まで)を整数で返します。
    * isdst(dst?): 夏時間があるなら true をなければ false を返します。
    * zone: タイムゾーンを表す文字列を返します。

    ((<localtime(3)|manual page>)) も参照しください。

    注意: C 言語の (({tm})) 構造体とは異なり、(({month})) は 1 月に対
    して 1 を返し、(({year})) は 1998 年に対して 1998 を返します。また、
    (({yday})) は 1 から数えます。

--- succ                ((<ruby 1.8 feature>))

    (({self})) に 1 秒足した Time オブジェクトを生成して返します。
    タイムゾーンは地方時になります。

        t = Time.now
        p t
        p t.succ
        # => Sun Jul 18 01:41:22 JST 2004
             Sun Jul 18 01:41:23 JST 2004

--- utc_offset
--- gmt_offset
--- gmtoff

    協定世界時との時差を秒を単位とする数値として返します。

    地方時が協定世界時よりも進んでいる場合(アジア、オーストラリアなど)
    には正の値、遅れている場合(アメリカなど)には負の値になります。

      p Time::now.zone  # => "JST"
      p Time::now.utc_offset
      # => 32400

    タイムゾーンが協定世界時に設定されている場合は 0 を返します。

      p Time::now.zone  # => "JST"
      p Time::now.getgm.utc_offset
      # => 0

    このメソッドは Ruby 1.6.7 で導入されました。

--- to_a

    時刻を10要素の配列で返します。その要素は順序も含めて以下の通りです。

    * sec:   秒 (整数 0-60)
    * min:   分 (整数 0-60)
    * hour:  時 (整数 1-24)
    * mday:  日 (整数)
    * mon:   月 (整数 1-12)
    * year:  年 (整数 2000年=2000)
    * wday:  曜日 (整数 0-6)
    * yday:  年内通算日 (整数 1-366)
    * isdst: 夏時間の有無 (true/false)
    * zone:  タイムゾーン (文字列)

        p Time.now      # => Mon Oct 20 06:02:10 JST 2003
        p Time.now.to_a # => [10, 2, 6, 20, 10, 2003, 1, 293, false, "JST"]

    要素の順序は C 言語の (({tm})) 構造体に合わせています。ただし、
    (({tm})) 構造体に zone はありません。

    注意: C 言語の (({tm})) 構造体とは異なり、(({month})) は 1 月に対
    して 1 を返し、(({year})) は 1998 年に対して 1998 を返します。また、
    (({yday})) は 1 から数えます。

--- to_f

    起算時からの経過秒数を浮動小数点数で返します。1 秒に満たない経過も
    表現されます。

--- to_i
--- tv_sec

    起算時からの経過秒数を整数で返します。

--- to_s

    時刻を ((<date(1)|manual page>)) のような形式の文字列に変換します。

        self.strftime("%a %b %d %H:%M:%S %Z %Y")

    と同じです。

        p Time.now.to_s # => "Mon Oct 20 06:02:10 JST 2003"

--- usec
--- tv_usec

    時刻のマイクロ秒の部分を返します。
