#
#  bln.py - a easyballoon compatible Saori module for ninix
#  Copyright (C) 2002, 2003 by Shyouzou Sugitani <shy@debian.or.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

# TODO:
# - font.face
# - \l

import os
import string
import StringIO
import random
import math
import time
import sys
import codecs

if os.environ.has_key('DISPLAY'):
    if not sys.modules.has_key('gtk'):
        try:
            import pygtk
            pygtk.require("2.0")
        except ImportError:
            pass
    import gtk
    import pango
else:
    gtk = None

import ninix.pix
import ninix.script

class Saori:
    def __init__(self):
	self.loaded = 0
        self.blns = {}
        self.sakura = None
    def use_sakura(self, sakura):
        self.sakura = sakura
    def load(self, dir=os.curdir):
        self.dir = dir
        result = 0
        if not self.sakura or not gtk:
            pass
        elif self.loaded:
	    result = 2
        else:
            self.blns = self.read_bln_txt(self.dir)
            if self.blns:
                self.loaded = 1
                result = 1
	return result
    def read_bln_txt(self, dir):
        blns = {}
        try:
            file = open(os.path.join(dir, 'bln.txt'), 'r')
            data = {}
            name = ''
            while 1:
                line = file.readline()
                if not line:
                    if name:
                        blns[name] = (data, {})
                    break # EOF
                line = string.strip(line)
                if not line:
                    continue
                if line[:2] == '//':
                    continue
                start = string.find(line, '[')
                if start >= 0:
                    if name:
                        blns[name] = (data, {})
                    data = {}
                    end = string.find(line, ']')
                    if end < 0:
                        end = len(line)
                    name = line[start+1:end]
                else:
                    comma = string.find(line, ',')
                    if comma >= 0:
                        key = string.strip(line[:comma])
                        value = string.strip(line[comma+1:])
                        data[key] = value
            return blns
        except:
            return None
    def unload(self):
        for name in self.blns.keys():
            data, bln = self.blns[name]
            for bln_id in bln.keys():
                if bln[bln_id]:
                    bln[bln_id].destroy()
                    del bln[bln_id]
        self.blns = {}
        self.loaded = 0
        return 1
    def request(self, req):
        type, argument = self.evaluate_request(req)
        header = StringIO.StringIO(req)
        line = header.readline()
        if not type:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'
        elif type == 'GET Version':
            return 'SAORI/1.0 204 No Content\r\n\r\n'
        elif type == 'EXECUTE':
            if len(argument) == 0:
                return 'SAORI/1.0 400 Bad Request\r\n\r\n'
            name = argument[0]
            if len(argument) >= 2:
                text = argument[1]
            else:
                text = ''
            if len(argument) >= 3:
                offset_x = int(argument[2])
            else:
                offset_x = 0
            if len(argument) >= 4:
                offset_y = int(argument[3])
            else:
                offset_y = 0
            if len(argument) >= 5:
                bln_id = argument[4]
            else:
                bln_id = ''
            if len(argument) >= 6 and argument[5] in ['1', '2']:
                update = int(argument[5])
            else:
                update = 0
            if self.blns.has_key(name):
                data, bln = self.blns[name]
                if bln.has_key(bln_id) and update == 0:
                    bln[bln_id].destroy()
                    del bln[bln_id]
                if text:
                    if update == 0 or not bln.has_key(bln_id):
                        bln[bln_id] = Balloon(self.sakura, self.dir, data, text,
                                              offset_x, offset_y, name, bln_id)
                    else:
                        bln[bln_id].update_script(text, update)
                self.blns[name] = (data, bln)
            elif name == 'clear':
                for name in self.blns.keys():
                    data, bln = self.blns[name]
                    if bln.has_key(bln_id) and \
                       bln[bln_id].get_state() != 'orusuban':
                        bln[bln_id].destroy()
                        del bln[bln_id]
                        self.blns[name] = (data, {})
            return 'SAORI/1.0 204 No Content\r\n\r\n'
    def evaluate_request(self, req):
        type = None
        argument = []
        charset = 'Shift_JIS' # default
        header = StringIO.StringIO(req)
        line = header.readline()
        if not line:
            return type, argument
        if line[-1] == '\n':
            line = line[:-1]
        line = string.strip(line)
        if not line:
            return type, argument
        for request in ['EXECUTE', 'GET Version']:
            if line[:len(request)] == request:
                type = request
                break
        while 1:
            line = header.readline()
            if not line:
                break # EOF
            if line[-1] == '\n':
                line = line[:-1]
            line = string.strip(line)
            if not line:
                continue
            colon = string.find(line, ':')
            if colon >= 0:
                key = string.strip(line[:colon])
                value = string.strip(line[colon+1:])
                if key == 'Charset':
                    try:
                        codecs.lookup(value)
                    except:
                        sys.stderr.write("Unsupported charset %s" % repr(charset))
                    else:
                        charset = value
                elif key[:8] == 'Argument':
                    argument.append(unicode(value, charset, 'replace'))
                else:
                    continue
        return type, argument

class Balloon:
    def __init__(self, sakura, dir, data, text, offset_x, offset_y, name, bln_id):
        self.dir = dir
        self.sakura = sakura
        self.dragged = 0
        self.name = name
        self.id = bln_id
        if not data.has_key('position'):
            self.position = 'sakura'
        else:
            self.position = data['position']
        self.window = gtk.Window(type=gtk.WINDOW_POPUP)
        self.window.connect("delete_event", self.delete)
        if data.has_key('clickerase') and data['clickerase'] == 'off':
            self.clickerase = 'off'
        else:
            self.clickerase = 'on'
        if data.has_key('dragmove.horizontal') and \
           data['dragmove.horizontal'] == 'on':
            self.dragmove_horizontal = 1
        else:
            self.dragmove_horizontal = 0
        if data.has_key('dragmove.vertical') and \
           data['dragmove.vertical'] == 'on':
            self.dragmove_vertical = 1
        else:
            self.dragmove_vertical = 0
        self.window.connect("button_press_event", self.button_press)
        self.window.connect("button_release_event", self.button_release)
        self.window.connect("motion_notify_event", self.motion_notify)
        self.window.connect("leave_notify_event", self.leave_notify)
        self.window.set_events(gtk.gdk.BUTTON_PRESS_MASK|
                               gtk.gdk.BUTTON_RELEASE_MASK|
                               gtk.gdk.POINTER_MOTION_MASK|
                               gtk.gdk.LEAVE_NOTIFY_MASK)
        scrn_w = gtk.gdk.screen_width()
        scrn_h = gtk.gdk.screen_height()
        scrn_h = scrn_h - self.get_sakura_status('getBottomMargin')
        s0_shown, s0_x, s0_y, s0_w, s0_h = self.get_sakura_status('getSurfaceSakura')
        s1_shown, s1_x, s1_y, s1_w, s1_h = self.get_sakura_status('getSurfaceKero')
        b0_shown, b0_x, b0_y, b0_w, b0_h = self.get_sakura_status('getBalloonSakura')
        b1_shown, b1_x, b1_y, b1_w, b1_h = self.get_sakura_status('getBalloonKero')
        if s0_x + s0_w/2 > scrn_w/2:
            self.direction0 = 0 # left
        else:
            self.direction0 = 1 # right
        if s1_x + s1_w/2 > scrn_w/2:
            self.direction1 = 0 # left
        else:
            self.direction1 = 1 # right            
        if ((self.position == 'sakura' and self.direction0) or \
            (self.position == 'kero' and self.direction1)) and \
            data.has_key('skin.right'):
            path = os.path.join(self.dir,
                                string.replace(data['skin.right'],
                                               '\\', '/'))
        elif (self.position == 'sakura' or self.position == 'kero') and \
             data.has_key('skin.left'):
            path = os.path.join(self.dir,
                                string.replace(data['skin.left'],
                                               '\\', '/'))
        elif data.has_key('skin'):
            path = os.path.join(self.dir,
                                string.replace(data['skin'],
                                               '\\', '/'))
        else:
            self.destroy()
        image, mask = ninix.pix.create_pixmap_from_file(path)
        self.x = 0
        self.y = 0 + self.get_sakura_status('getTopMargin')
        w, h = image.get_size()
        if self.position == 'lefttop':
            pass
        elif self.position == 'leftbottom':
            self.y = scrn_h - h
        elif self.position == 'righttop':
            self.x = scrn_w - w
        elif self.position == 'rightbottom':
            self.x = scrn_w - w
            self.y = scrn_h - h
        elif self.position == 'center':
            self.x = (scrn_w - w)/2
            self.y = (scrn_h - h)/2
        elif self.position == 'leftcenter':
            self.x = 0
            self.y = (scrn_h - h)/2
        elif self.position == 'rightcenter':
            self.x = scrn_w -w
            self.y = (scrn_h - h)/2
        elif self.position == 'centertop':
            self.x = (scrn_w - w)/2
        elif self.position == 'centerbottom':
            self.x = (scrn_w - w)/2
            self.y = scrn_h - h
        elif self.position == 'sakura':
            if self.direction0: # right
                self.x = s0_x + s0_w
            else:
                self.x = s0_x - w
            self.y = s0_y
        elif self.position == 'kero':
            if self.direction1: # right
                self.x = s1_x + s1_w
            else:
                self.x = s1_x - w
            self.y = s1_y
        elif self.position == 'sakurab':
            self.x = b0_x
            self.y = b0_y
        elif self.position == 'kerob':
            self.x = b1_x
            self.y = b1_y
        if data.has_key('offset.x'):
            if (self.position == 'sakura' and not self.direction0) or \
               (self.position == 'kero' and not self.direction1):
                self.x = self.x - int(data['offset.x'])
            else:
                self.x = self.x + int(data['offset.x'])
        if data.has_key('offset.y'):
            self.y = self.y + int(data['offset.y'])
        if data.has_key('offset.random'):
            self.x = self.x + int(data['offset.random']) * random.randrange(-1, 2)
            self.y = self.y + int(data['offset.random']) * random.randrange(-1, 2)
        if (self.position == 'sakura' and not self.direction0) or \
           (self.position == 'kero' and not self.direction1):
            self.x = self.x - offset_x
        else:
            self.x = self.x + offset_x
        self.y = self.y + offset_y
        self.window.move(self.x, self.y)
        gtk.gdk.flush()
        self.left = 0
        self.right = w
        self.top = 0
        bottom = h
        if data.has_key('disparea.left'):
            self.left = int(data['disparea.left'])
        if data.has_key('disparea.right'):
            self.right = int(data['disparea.right'])
        if data.has_key('disparea.top'):
            self.top = int(data['disparea.top'])
        if data.has_key('disparea.bottom'):
            self.bottom = int(data['disparea.bottom'])
        self.mask_pixmap = mask
        self.window.shape_combine_mask(self.mask_pixmap, 0, 0)
        self.script = None
        self.darea = gtk.DrawingArea()
        self.darea.set_events(gtk.gdk.EXPOSURE_MASK)
        self.darea.connect("expose_event", self.redraw)
        self.darea.set_size_request(w, h)
        self.darea.show()
        self.window.add(self.darea)
        self.darea.realize()
        self.surface_gc = self.darea.window.new_gc()
        self.darea.window.set_back_pixmap(image, gtk.FALSE)
        self.layout = None
        if text != 'noscript' and (self.right-self.left) and (self.bottom-self.top):
            self.script = text
            if data.has_key('font.color'):
                fontcolor_r = int(data['font.color'][:2], 16)
                fontcolor_g = int(data['font.color'][2:4], 16)
                fontcolor_b = int(data['font.color'][4:6], 16)
                cmap = self.darea.get_colormap()
                self.surface_gc.foreground = cmap.alloc_color(
                    "#%02x%02x%02x" % (fontcolor_r, fontcolor_g, fontcolor_b))
            self.font_size = 12 # default size
            if data.has_key('font.size'):
                self.font_size = int(data['font.size'])
            self.layout = pango.Layout(self.darea.get_pango_context())
            self.font_desc = pango.FontDescription()
            self.font_desc.set_family('Sans') # FIXME
            self.font_desc.set_size((self.font_size-3) * 1024) # size * PANGO_SCALE
            if data.has_key('font.bold') and data['font.bold'] == 'on':
                self.font_desc.set_weight(pango.WEIGHT_BOLD)
            self.layout.set_font_description(self.font_desc)
            self.layout.set_wrap(pango.WRAP_CHAR)
            self.layout.set_width((self.right - self.left) * 1024)
        if data.has_key('slide.vx'):
            self.slide_vx = int(data['slide.vx'])
        else:
            self.slide_vx = 0
        if data.has_key('slide.vy'):
            self.slide_vy = int(data['slide.vy'])
        else:
            self.slide_vy = 0
        if data.has_key('slide.autostop'):
            self.slide_autostop = int(data['slide.autostop'])
        else:
            self.slide_autostop = 0
        if data.has_key('action.method') and \
           data['action.method'] in ['sinwave', 'vibrate']:
            action = data['action.method']
            ref0 = 0
            ref1 = 0
            ref2 = 0
            ref3 = 0
            if data.has_key('action.reference0'):
                ref0 = int(data['action.reference0'])
            if data.has_key('action.reference1'):
                ref1 = int(data['action.reference1'])
            if data.has_key('action.reference2'):
                ref2 = int(data['action.reference2'])
            if data.has_key('action.reference3'):
                ref3 = int(data['action.reference3'])
            if ref2:
                self.action = {'method': action,
                               'ref0': ref0,
                               'ref1': ref1,
                               'ref2': ref2,
                               'ref3': ref3}
            else:
                self.action = None
        else:
            self.action = None
        self.move_notify_time = None
        self.life_time = None
        self.state = ''
        if data.has_key('life'):
            life = data['life']
            if life == 'auto':
                self.life_time = 16000
            elif life in ['infinitely', '0']:
                pass
            elif life == 'orusuban':
                self.state = 'orusuban'
            else:
                try:
                    self.life_time = int(life)
                except:
                    pass
        else:
            self.life_time = 16000
        self.start_time = time.time()
        if data.has_key('startdelay'):
            self.startdelay = int(data['startdelay'])
        else:
            self.startdelay = 0
        self.nooverlap = 0
        if data.has_key('nooverlap'):
            self.nooverlap = 1
        self.talking = self.get_sakura_status('isTalking')
        self.move_notify_time = time.time()
        self.timeout_id = None
        self.visible = 0
        self.x_root = None
        self.y_root = None
        self.action_x = 0
        self.action_y = 0
        self.vx = 0
        self.vy = 0
        self.text_pos_x = self.left
        self.text_pos_y = self.top
        self.processed_script = None
        self.processed_text = ''
        self.text = ''
        self.script_wait = None
        self.quick_session = 0
        self.script_parser = ninix.script.Parser(error="loose")
        try:
            self.processed_script = self.script_parser.parse(self.script)
        except ninix.script.ParserError, e:
            self.processed_script = None
            print "-" * 50
            print e
            print script                                    
        self.timeout_id = gtk.timeout_add(10, self.do_idle_tasks)
    def update_script(self, text, mode):
        if text:
            if mode == 2 and self.script != None:
                self.script = self.script + text
            else:
                self.script = text
            self.processed_script = None
            self.processed_text = ''
            self.text = ''
            self.script_wait = None
            self.quick_session = 0
            try:
                self.processed_script = self.script_parser.parse(self.script)
            except ninix.script.ParserError, e:
                self.processed_script = None
                print "-" * 50
                print e
                print script                                    
    def get_sakura_status(self, id): # FIXME
        if id == 'getSurfaceSakura':
            if self.sakura.surface.window and \
               self.sakura.surface.window[0].shown:
                s0_shown = 1
            else:
                s0_shown = 0
            try:
                s0_x, s0_y = self.sakura.surface.get_position(0)
                s0_w, s0_h = self.sakura.surface.get_surface_size(0)
            except:
                s0_x, s0_y = 0, 0
                s0_w, s0_h = 0, 0
            return s0_shown, s0_x, s0_y, s0_w, s0_h
        elif id == 'getSurfaceKero':
            if self.sakura.surface.window and \
               self.sakura.surface.window[1].shown:
                s1_shown = 1
            else:
                s1_shown = 0
            try:
                s1_x, s1_y = self.sakura.surface.get_position(1)
                s1_w, s1_h = self.sakura.surface.get_surface_size(1)
            except:
                s1_x, s1_y = 0, 0
                s1_w, s1_h = 0, 0
            return s1_shown, s1_x, s1_y, s1_w, s1_h
        elif id == 'getBalloonSakura':
            if self.sakura.balloon.window and \
               self.sakura.balloon.window[0].shown:
                b0_shown = 1
            else:
                b0_shown = 0
            try:
                b0_x, b0_y = self.sakura.balloon.get_position(0)
                b0_w, b0_h = self.sakura.balloon.get_balloon_size(0)
            except:
                b0_x, b0_y = 0, 0
                b0_w, b0_h = 0, 0
            return b0_shown, b0_x, b0_y, b0_w, b0_h
        elif id == 'getBalloonKero':
            if self.sakura.balloon.window and \
               self.sakura.balloon.window[1].shown:
                b1_shown = 1
            else:
                b1_shown = 0
            try:
                b1_x, b1_y = self.sakura.balloon.get_position(1)
                b1_w, b1_h = self.sakura.balloon.get_balloon_size(1)
            except:
                b1_x, b1_y = 0, 0
                b1_w, b1_h = 0, 0
            return b1_shown, b1_x, b1_y, b1_w, b1_h
        elif id == 'isTalking':
            talking = 0
            try:
                if self.sakura.processed_script or \
                   self.sakura.processed_text:
                    talking = 1
            except:
                pass
            return talking
        elif id == 'getBottomMargin':
            return self.sakura.bottom_margin
        elif id == 'getTopMargin':
            return self.sakura.top_margin
        else:
            return None
    def do_idle_tasks(self):
        if not self.window:
            return None
        s0_shown, s0_x, s0_y, s0_w, s0_h = self.get_sakura_status('getSurfaceSakura')
        s1_shown, s1_x, s1_y, s1_w, s1_h = self.get_sakura_status('getSurfaceKero')
        b0_shown, b0_x, b0_y, b0_w, b0_h = self.get_sakura_status('getBalloonSakura')
        b1_shown, b1_x, b1_y, b1_w, b1_h = self.get_sakura_status('getBalloonKero')
        sakura_talking = self.get_sakura_status('isTalking')
        if self.state == 'orusuban':
            if self.visible:
                if s0_shown or s1_shown:
                    self.destroy()
                    return None
            else:
                if not s0_shown and not s1_shown:
                    self.start_time = time.time()
                    self.visible = 1
                    self.window.show()
                    self.life_time = 300000
        else:
            if self.visible:
                if self.position == 'sakura' and not s0_shown:
                    self.destroy()
                    return None
                if self.position == 'kero' and not s1_shown:
                    self.destroy()
                    return None
                if self.position == 'sakurab' and not b0_shown:
                    self.destroy()
                    return None
                if self.position == 'kerob' and not b1_shown:
                    self.destroy()
                    return None
                if self.nooverlap and \
                   not self.talking and sakura_talking:
                    self.destroy()
                    return None
            else:
                if time.time() - self.start_time >= self.startdelay * 0.001:
                    self.start_time = time.time()
                    self.visible = 1
                    self.window.show()
        if self.visible:
            if self.life_time:
                if time.time() - self.start_time >= self.life_time * 0.001 and \
                   not (self.processed_script or self.processed_text):
                    self.destroy()
                    return None
                else:
                    last_time = self.life_time * 0.001 + self.start_time - time.time()
            if self.action:
                if  self.action['method'] == 'sinwave':
                    offset = self.action['ref1'] \
                             * math.sin(2.0 * math.pi
                                        * float(int((time.time() - self.start_time) * 1000) % self.action['ref2'])
                                        / self.action['ref2'])
                    if self.action['ref0']:
                        self.action_y = offset
                    else:
                        self.action_x = offset
                elif self.action['method'] == 'vibrate':
                    offset = (int((time.time() - self.start_time) * 1000) / self.action['ref2']) % 2
                    self.action_x = offset * self.action['ref0']
                    self.action_y = offset * self.action['ref1']
            if (self.slide_vx != 0 or self.slide_vy != 0) and \
                   self.slide_autostop > 0 and \
                   self.slide_autostop * 0.001 + 0.05 <= time.time() - self.start_time:
                self.vx = int((self.slide_autostop / 50.0 + 1) * self.slide_vx)
                if (self.position == 'sakura' and not self.direction0) or \
                   (self.position == 'kero' and not self.direction1):
                    self.vx = -self.vx
                self.slide_vx = 0
                self.vy = int((self.slide_autostop / 50.0 + 1) * self.slide_vy)
                self.slide_vy = 0
            if self.slide_vx != 0:
                self.vx = int(((time.time() - self.start_time) * self.slide_vx) / 50 * 1000.0)
                if (self.position == 'sakura' and not self.direction0) or \
                   (self.position == 'kero' and not self.direction1):
                    self.vx = -self.vx
            if self.slide_vy != 0:
                self.vy = int(((time.time() - self.start_time) * self.slide_vy) / 50 * 1000.0)
            self.window.move(int(self.x + self.action_x + self.vx),
                             int(self.y + self.action_y + self.vy))
            if self.processed_script or self.processed_text:
                self.interpret_script()
        if self.talking and not sakura_talking:
            self.talking = 0
        else:
            self.talking = sakura_talking
        return gtk.TRUE
    def redraw(self, widget, event):
        x, y, w, h = event.area
        self.darea.window.clear()
        if self.layout:
            self.darea.window.draw_layout(self.surface_gc, self.left, self.top, self.layout)
    def get_state(self):
        return self.state
    def interpret_script(self):
        if self.script_wait is not None:
            if time.time() < self.script_wait:
                return
            self.script_wait = None
        if self.processed_text:
            if self.quick_session or self.state == 'orusuban':
                self.text = self.text + self.processed_text
                self.draw_text(self.text)
                self.processed_text = ''
            else:
                self.text = self.text + self.processed_text[0]
                self.draw_text(self.text)
                self.processed_text = self.processed_text[1:]
                self.script_wait = time.time() + 0.014
            return
        node = self.processed_script.pop(0)
        if node[0] == ninix.script.SCRIPT_TAG:
            name, args = node[1], node[2:]
            if name == r'\n':
                self.text = self.text + '\n'
                self.draw_text(self.text)
            elif name == r'\w':
                if len(args) > 0:
                    try:
                        amount = int(args[0]) * 0.05 - 0.01
                    except ValueError:
                        amount = 0
                else:
                    amount = 1 * 0.05 - 0.01
                if amount > 0:
                    self.script_wait = time.time() + amount
            elif name == r'\b':
                if len(args) > 0:
                    try:
                        amount = int(args[0])
                    except ValueError:
                        amount = 0
                else:
                    amount = 1
                if amount > 0:
                    self.text = self.text[:-amount]
            elif name == r'\c':
                self.text = ''
            elif name == r'\_q':
                self.quick_session = not self.quick_session
            elif name == r'\l':
                self.life_time = None
                self.update_script('', 2)
        elif node[0] == ninix.script.SCRIPT_TEXT:
            text = ''
            for chunk in node[1]:
                text = text + chunk[1]
            self.processed_text = text
    def draw_text(self, text):
        try:
            self.layout.set_text(text)
        except:
            self.layout.set_text(text, -1) # pygtk <= 1.99.14
        self.darea.queue_draw()
    def button_press(self, window, event):
        self.x_root = event.x_root
        self.y_root = event.y_root
        if event.type == gtk.gdk._2BUTTON_PRESS:
            self.sakura.notify_event('OnEBMouseDoubleClick', self.name, int(event.x), int(event.y), self.id)
        return gtk.TRUE
    def button_release(self, window, event):
        if self.dragged:
            self.dragged = 0
        self.x_root = None
        self.y_root = None
        if event.type == gtk.gdk.BUTTON_RELEASE:
            if event.button == 1:
                self.sakura.notify_event('OnEBMouseClick', self.name, int(event.x), int(event.y), self.id, 0)
            elif event.button == 3:
                self.sakura.notify_event('OnEBMouseClick', self.name, int(event.x), int(event.y), self.id, 1)
        if self.clickerase == 'on':
            self.destroy()
        return gtk.TRUE
    def motion_notify(self, window, event):
        if self.x_root is not None and \
           self.y_root is not None:
            x_delta = int(event.x_root - self.x_root)
            y_delta = int(event.y_root - self.y_root)
            if event.state & gtk.gdk.BUTTON1_MASK:
                self.dragged = 1
                if self.dragmove_horizontal:
                    self.x = self.x + x_delta
                if self.dragmove_vertical:
                    self.y = self.y + y_delta
                self.window.move(self.x + self.action_x + self.vx,
                                 self.y + self.action_y + self.vy)
                self.x_root = event.x_root
                self.y_root = event.y_root
        if self.move_notify_time == None or \
           time.time() - self.move_notify_time > 500 * 0.001:
            self.sakura.notify_event('OnEBMouseMove', self.name, int(event.x), int(event.y), self.id)
            self.move_notify_time = time.time()
        return gtk.TRUE
    def leave_notify(self, window, event):
        self.move_notify_time = None
    def delete(self, window, event):
        return gtk.TRUE
    def destroy(self):
        self.visible = 0
        if self.window:
            self.window.destroy()
            self.window = None
        if self.timeout_id:
            gtk.timeout_remove(self.timeout_id)
            self.timeout_id = None
