import re
import string
import sys

def print_error(message):
    sys.stderr.write(message + "\n")

class MAYUNA:
    def __init__(self, id):
        self.id = id
        self.patterns = []
    def get_id(self):
        return self.id
    def get_patterns(self):
        return self.patterns
    def add_pattern(self, surface, method, args):
        self.patterns.append((surface, method, args))

re_interval = re.compile("^([0-9]+)interval$")
re_interval_value = re.compile("^(bind)$")
re_pattern = re.compile(r"^([0-9]+|-[12])\s*,\s*([0-9]+)\s*,\s*(bind|add|reduce|insert)\s*,?\s*([+-]?[0-9]+)?\s*,?\s*([+-]?[0-9]+)?\s*,?\s*(\[[0-9]+(\.[0-9]+)*\])?$")

def get_mayuna(config):
    buffer = []
    for key, value in config.items():
        match = re_interval.match(key)
        if not match or not re_interval_value.match(value):
            continue
        buffer.append((int(match.group(1)), value))
    mayuna = []
    for id, interval in buffer:
        if interval == "bind":
            actor = MAYUNA(id)
        try:
            for n in range(128): # up to 128 patterns (0 - 127)
                key = str(id) + "pattern" + str(n)
                if not config.has_key(key):
                    key = str(id) + "patturn" + str(n)
                    if not config.has_key(key):
                        break
                pattern = config[key]                
                match = re_pattern.match(pattern)
                if not match:
                    raise ValueError, "unsupported pattern: %s" % pattern
                surface = str(int(match.group(1)))
                method = match.group(3)
                if method == "start":
                    group = match.group(4)
                    if group is None:
                        raise ValueError, "syntax error: %s" % pattern
                    args = [int(group)]
                elif method == "alternativestart":
                    list = match.group(6)
                    if list is None:
                        raise ValueError, "syntax error: %s" % pattern
                    args = map(int, string.split(list[1:-1], "."))
                else:
                    if surface in ["-1", "-2"]:
                        x = 0
                        y = 0
                    else:
                        x = int(match.group(4) or 0)
                        y = int(match.group(5) or 0)
                    args = [x, y]
                actor.add_pattern(surface, method, args)
        except ValueError, error:
            print_error("mayuna.py: " + str(error))
            continue
        if not actor.get_patterns():
            print_error("mayuna.py: animation group #%d has no pattern (ignored)" % id)
            continue
        mayuna.append(actor)
    mayuna.sort(lambda a1, a2: cmp(a1.get_id(), a2.get_id()))
    return mayuna

# find ~/.ninix -name 'surface*a.txt' | xargs python mayuna.py
def test():
    import sys
    import ninix.config
    if len(sys.argv) == 1:
        print "Usage:", sys.argv[0], "[surface??a.txt ...]"
    for file in sys.argv[1:]:
        print "Reading", file, "..."
        for actor in get_mayuna(ninix.config.open(file)):
            print "#%d" % actor.get_id()
            print "number of patterns =", len(actor.get_patterns())
            for pattern in actor.get_patterns():
                print "surface=%s, method=%s, args=%s" % pattern

if __name__ == "__main__":
    test()
