/*
 *
 * UNICON - The Console Chinese & I18N
 * Copyright (c) 1999-2000
 *
 * This file is part of UNICON, a console Chinese & I18N
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * See the file COPYING directory of this archive
 * Author: see CREDITS
 */

#include <linux/module.h>
#include <linux/fb_doublebyte.h>
#include "font_eucjp16.h"
#define min1 0x81
#define max1 0xfc
// 0x2121 -- 0x7424

#ifdef MODULE_LICENSE
MODULE_LICENSE("GPL");
#endif

static int is_hz_left(int c)
{
        return ((c >= 0x81 && c <= 0x9f) || (c >= 0xe0 && c <= 0xfc));
}

static int is_hz_right(int c)
{
        return ((c >= 0x40 && c <= 0x7e) || (c >= 0x80 && c <= 0xfc));
}

static int index_sjis(int left, int right)
{
        int ch1, ch2;

        if ( !is_hz_left(left) || !is_hz_right(right) ) return -512;

        ch1 = left;
        ch2 = right;

        if ( ch1 <= 0x9f )
                ch1 -= 0x71;
        else
                ch1 -= 0xb1;
        ch1 *= 2;
        ++ch1;

        if ( ch2 >= 0x7f )
                --ch2;
        if ( ch2 >= 0x9e ) {
                ch2 -= 0x7d;
                ++ch1;
        } else {
                ch2 -= 0x1f;
        }

        if (ch1 > 0x29)
                return ((ch2 - 0x40 + (ch1 - 0x25) * 96) << 5);
        else
                return ((ch2 - 0x20 + (ch1 - 0x20) * 96) << 5);
}

#ifdef MODULE
static struct double_byte db_sjis =
#else
struct double_byte db_sjis =
#endif
{
	0,
	"SJIS",
	is_hz_left,
	is_hz_right,
	index_sjis,
	16,16,
	max_jis16,
	font_jis16
};

#ifdef MODULE
int init_module(void)
{
        if (UniconFontManager == (DBFontManager *) 0)
            return 1;
        if (UniconFontManager->registerfont (XL_DB_SJIS, &db_sjis) == 0)
            return 1;
        return 0;
}
	
void cleanup_module(void)
{
        if (UniconFontManager == (DBFontManager *) 0)
            return;
        UniconFontManager->unregisterfont (XL_DB_SJIS);
}	
#endif

