#ifndef _ASM_POWERPC_ISERIES_ISERIES_IO_H
#define _ASM_POWERPC_ISERIES_ISERIES_IO_H


#ifdef CONFIG_PPC_ISERIES
#include <linux/types.h>
/*
 * Created by Allan Trautman on Thu Dec 28 2000.
 *
 * Remaps the io.h for the iSeries Io
 * Copyright (C) 2000  Allan H Trautman, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the:
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * Change Activity:
 *   Created December 28, 2000
 * End Change Activity
 */

#ifdef CONFIG_PCI
extern u8   iSeries_Read_Byte(const volatile void __iomem * IoAddress);
extern u16  iSeries_Read_Word(const volatile void __iomem * IoAddress);
extern u32  iSeries_Read_Long(const volatile void __iomem * IoAddress);
extern void iSeries_Write_Byte(u8  IoData, volatile void __iomem * IoAddress);
extern void iSeries_Write_Word(u16 IoData, volatile void __iomem * IoAddress);
extern void iSeries_Write_Long(u32 IoData, volatile void __iomem * IoAddress);

extern void iSeries_memset_io(volatile void __iomem *dest, char x, size_t n);
extern void iSeries_memcpy_toio(volatile void __iomem *dest, void *source,
		size_t n);
extern void iSeries_memcpy_fromio(void *dest,
		const volatile void __iomem *source, size_t n);
#else
static inline u8 iSeries_Read_Byte(const volatile void __iomem *IoAddress)
{
	return 0xff;
}

static inline void iSeries_Write_Byte(u8 IoData,
		volatile void __iomem *IoAddress)
{
}
#endif	/* CONFIG_PCI */

#endif /* CONFIG_PPC_ISERIES */
#endif /* _ASM_POWERPC_ISERIES_ISERIES_IO_H */
