/*
 * kernel/power/io.h
 *
 * Copyright (C) 2005-2006 Nigel Cunningham <nigel@suspend2.net>
 *
 * This file is released under the GPLv2.
 *
 * It contains high level IO routines for suspending.
 *
 */

#include "pagedir.h"

/* Non-module data saved in our image header */
struct suspend_header {
	u32 version_code;
	unsigned long num_physpages;
	unsigned long orig_mem_free;
	char machine[65];
	char version[65];
	int num_cpus;
	int page_size;
	int pageset_2_size;
	int param0;
	int param1;
	int param2;
	int param3;
	int progress0;
	int progress1;
	int progress2;
	int progress3;
	int io_time[2][2];
	struct pagedir pagedir;
	dev_t root_fs;
};

extern int write_pageset(struct pagedir *pagedir, int whichtowrite);
extern int write_image_header(void);
extern int read_pageset1(void);
extern int read_pageset2(int overwrittenpagesonly);

extern int suspend_attempt_to_parse_resume_device(void);
extern void attempt_to_parse_resume_device2(void);
extern dev_t name_to_dev_t(char *line);
extern __nosavedata unsigned long bytes_in, bytes_out;
extern char *get_have_image_data(void);
